/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import org.drools.common.InternalFactHandle;
import org.drools.reteoo.FactHandleMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.util.AbstractHashTable;
import org.drools.util.Entry;
import org.drools.util.Iterator;

public class FactHashTable
extends AbstractHashTable
implements FactHandleMemory {
    private static final long serialVersionUID = 400L;

    public FactHashTable() {
        this(16, 0.75f);
    }

    public FactHashTable(int capacity, float loadFactor) {
        super(capacity, loadFactor);
    }

    public Iterator iterator(ReteTuple tuple) {
        return this.iterator();
    }

    public boolean add(InternalFactHandle handle) {
        return this.add(handle, true);
    }

    public boolean add(InternalFactHandle handle, boolean checkExists) {
        int hashCode = this.comparator.hashCodeOf(handle);
        int index = this.indexOf(hashCode, this.table.length);
        if (checkExists) {
            for (AbstractHashTable.FactEntryImpl current = (AbstractHashTable.FactEntryImpl)this.table[index]; current != null; current = (AbstractHashTable.FactEntryImpl)current.getNext()) {
                if (hashCode != current.hashCode || handle.getId() != current.handle.getId()) continue;
                return false;
            }
        }
        AbstractHashTable.FactEntryImpl entry = new AbstractHashTable.FactEntryImpl(handle, hashCode);
        entry.next = this.table[index];
        this.table[index] = entry;
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return true;
    }

    public boolean contains(InternalFactHandle handle) {
        int hashCode = this.comparator.hashCodeOf(handle);
        int index = this.indexOf(hashCode, this.table.length);
        for (AbstractHashTable.FactEntryImpl current = (AbstractHashTable.FactEntryImpl)this.table[index]; current != null; current = (AbstractHashTable.FactEntryImpl)current.getNext()) {
            if (hashCode != current.hashCode || handle.getId() != current.handle.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean remove(InternalFactHandle handle) {
        AbstractHashTable.FactEntryImpl previous;
        int hashCode = this.comparator.hashCodeOf(handle);
        int index = this.indexOf(hashCode, this.table.length);
        AbstractHashTable.FactEntryImpl current = previous = (AbstractHashTable.FactEntryImpl)this.table[index];
        while (current != null) {
            AbstractHashTable.FactEntryImpl next = (AbstractHashTable.FactEntryImpl)current.getNext();
            if (hashCode == current.hashCode && handle.getId() == current.handle.getId()) {
                if (previous == current) {
                    this.table[index] = next;
                } else {
                    previous.setNext(next);
                }
                current.setNext(null);
                --this.size;
                return true;
            }
            previous = current;
            current = next;
        }
        return false;
    }

    public Entry getBucket(Object object) {
        int hashCode = this.comparator.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        return this.table[index];
    }

    public boolean isIndexed() {
        return false;
    }
}

