/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ChainedProperties
implements Serializable {
    private final List props;
    private final List defaultProps;

    public ChainedProperties(String confFileName) {
        this(null, confFileName);
    }

    public ChainedProperties(ClassLoader classLoader, String confFileName) {
        this(classLoader, confFileName, true);
    }

    public ChainedProperties(ClassLoader classLoader, String confFileName, boolean populateDefaults) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.props = new ArrayList();
        this.defaultProps = new ArrayList();
        this.addProperties(System.getProperties());
        this.loadProperties(System.getProperty("drools." + confFileName), this.props);
        this.loadProperties(System.getProperty("user.home") + "/drools." + confFileName, this.props);
        this.loadProperties("drools." + confFileName, this.props);
        ClassLoader confClassLoader = classLoader;
        if (confClassLoader != null) {
            this.loadProperties(confClassLoader.getResource("META-INF/drools." + confFileName), this.props);
        }
        if ((confClassLoader = this.getClass().getClassLoader()) != null && confClassLoader != classLoader) {
            this.loadProperties(confClassLoader.getResource("META-INF/drools." + confFileName), this.props);
        }
        if ((confClassLoader = Thread.currentThread().getContextClassLoader()) != null && confClassLoader != classLoader) {
            this.loadProperties(confClassLoader.getResource("META-INF/drools." + confFileName), this.props);
        }
        if ((confClassLoader = ClassLoader.getSystemClassLoader()) != null && confClassLoader != classLoader) {
            this.loadProperties(confClassLoader.getResource("META-INF/drools." + confFileName), this.props);
        }
        if (!populateDefaults) {
            return;
        }
        confClassLoader = classLoader;
        URL defaultURL = null;
        if (confClassLoader != null) {
            defaultURL = confClassLoader.getResource("META-INF/drools.default." + confFileName);
        }
        if (defaultURL == null && (confClassLoader = this.getClass().getClassLoader()) != null && confClassLoader != classLoader) {
            defaultURL = confClassLoader.getResource("META-INF/drools.default." + confFileName);
        }
        if (defaultURL == null && (confClassLoader = Thread.currentThread().getContextClassLoader()) != null && confClassLoader != classLoader) {
            defaultURL = confClassLoader.getResource("META-INF/drools.default." + confFileName);
        }
        if (defaultURL == null && (confClassLoader = ClassLoader.getSystemClassLoader()) != null && confClassLoader != classLoader) {
            defaultURL = confClassLoader.getResource("META-INF/drools.default." + confFileName);
        }
        if (defaultURL != null) {
            this.loadProperties(defaultURL, this.defaultProps);
        }
    }

    public void addProperties(Properties properties) {
        this.props.add(properties);
    }

    public String getProperty(String key, String defaultValue) {
        String value;
        block2: {
            Properties props;
            value = null;
            Iterator it = this.props.iterator();
            while (it.hasNext() && (value = (props = (Properties)it.next()).getProperty(key)) == null) {
            }
            if (value != null) break block2;
            it = this.defaultProps.iterator();
            while (it.hasNext() && (value = (props = (Properties)it.next()).getProperty(key)) == null) {
            }
        }
        return value != null ? value : defaultValue;
    }

    public void mapStartsWith(Map map, String startsWith, boolean includeSubProperties) {
        Properties props;
        Iterator it = this.props.iterator();
        while (it.hasNext()) {
            props = (Properties)it.next();
            this.mapStartsWith(map, props, startsWith, includeSubProperties);
        }
        it = this.defaultProps.iterator();
        while (it.hasNext()) {
            props = (Properties)it.next();
            this.mapStartsWith(map, props, startsWith, includeSubProperties);
        }
    }

    private void mapStartsWith(Map map, Properties properties, String startsWith, boolean includeSubProperties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(startsWith) || !includeSubProperties && key.substring(startsWith.length() + 1).indexOf(46) > 0 || map.containsKey(key)) continue;
            map.put(key, properties.getProperty(key));
        }
    }

    private void loadProperties(String fileName, List chain) {
        File file;
        if (fileName != null && (file = new File(fileName)) != null && file.exists()) {
            try {
                this.loadProperties(file.toURL(), chain);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("file.toURL() failed for drools.packagebuilder.conf properties value '" + file + "'");
            }
        }
    }

    private void loadProperties(URL confURL, List chain) {
        if (confURL != null) {
            Properties properties = new Properties();
            try {
                properties.load(confURL.openStream());
                chain.add(properties);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

