/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spi;

import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassObjectType;
import org.drools.base.ShadowProxy;
import org.drools.base.ValueType;
import org.drools.common.InternalWorkingMemory;
import org.drools.facttemplates.Fact;
import org.drools.spi.Extractor;
import org.drools.spi.ObjectType;

public class PatternExtractor
implements Extractor {
    private static final long serialVersionUID = 400L;
    private ObjectType objectType;

    public PatternExtractor(ObjectType objectType) {
        this.objectType = objectType;
    }

    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return object instanceof ShadowProxy ? ((ShadowProxy)object).getShadowedObject() : object;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public Class getExtractToClass() {
        if (this.objectType instanceof ClassObjectType) {
            return ((ClassObjectType)this.objectType).getClassType();
        }
        return Fact.class;
    }

    public ValueType getValueType() {
        return this.objectType.getValueType();
    }

    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isBoolean()) {
            return (Boolean)object;
        }
        throw new RuntimeDroolsException("Conversion to boolean not supported for type: " + object.getClass());
    }

    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)object).byteValue();
        }
        throw new RuntimeDroolsException("Conversion to byte not supported for type: " + object.getClass());
    }

    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isChar()) {
            return ((Character)object).charValue();
        }
        throw new RuntimeDroolsException("Conversion to char not supported for type: " + object.getClass());
    }

    public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)object).doubleValue();
        }
        throw new RuntimeDroolsException("Conversion to double not supported for type: " + object.getClass());
    }

    public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)object).floatValue();
        }
        throw new RuntimeDroolsException("Conversion to float not supported for type: " + object.getClass());
    }

    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)object).intValue();
        }
        throw new RuntimeDroolsException("Conversion to int not supported for type: " + object.getClass());
    }

    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)object).longValue();
        }
        throw new RuntimeDroolsException("Conversion to long not supported for type: " + object.getClass());
    }

    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)object).shortValue();
        }
        throw new RuntimeDroolsException("Conversion to short not supported for type: " + object.getClass());
    }

    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getValue", InternalWorkingMemory.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
        return this.getValue(workingMemory, object) == null;
    }

    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        return this.getValue(workingMemory, object).hashCode();
    }

    public int hashCode() {
        return this.objectType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PatternExtractor)) {
            return false;
        }
        PatternExtractor other = (PatternExtractor)obj;
        return this.objectType.equals(other.objectType);
    }

    public boolean isGlobal() {
        return false;
    }
}

