/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.ruleflow.core.Connection;
import org.drools.ruleflow.core.EndNode;
import org.drools.ruleflow.core.Join;
import org.drools.ruleflow.core.MilestoneNode;
import org.drools.ruleflow.core.Node;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.ruleflow.core.RuleFlowProcessValidationError;
import org.drools.ruleflow.core.RuleFlowProcessValidator;
import org.drools.ruleflow.core.RuleSetNode;
import org.drools.ruleflow.core.Split;
import org.drools.ruleflow.core.StartNode;
import org.drools.ruleflow.core.Variable;
import org.drools.ruleflow.core.impl.RuleFlowProcessValidationErrorImpl;

public class RuleFlowProcessValidatorImpl
implements RuleFlowProcessValidator {
    private static RuleFlowProcessValidatorImpl instance;

    private RuleFlowProcessValidatorImpl() {
    }

    public static RuleFlowProcessValidatorImpl getInstance() {
        if (instance == null) {
            instance = new RuleFlowProcessValidatorImpl();
        }
        return instance;
    }

    public RuleFlowProcessValidationError[] validateProcess(RuleFlowProcess process) {
        ArrayList<RuleFlowProcessValidationErrorImpl> errors = new ArrayList<RuleFlowProcessValidationErrorImpl>();
        if (process.getName() == null) {
            errors.add(new RuleFlowProcessValidationErrorImpl("RuleFlow process has no name."));
        }
        if (process.getId() == null || "".equals(process.getId())) {
            errors.add(new RuleFlowProcessValidationErrorImpl("RuleFlow process has no id."));
        }
        if (process.getStart() == null) {
            errors.add(new RuleFlowProcessValidationErrorImpl("RuleFlow process has no start node."));
        }
        boolean startNodeFound = false;
        boolean endNodeFound = false;
        Node[] nodes = process.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (node instanceof StartNode) {
                StartNode startNode = (StartNode)node;
                startNodeFound = true;
                if (startNode.getTo() != null) continue;
                errors.add(new RuleFlowProcessValidationErrorImpl("Start node has no outgoing connection."));
                continue;
            }
            if (node instanceof EndNode) {
                EndNode endNode = (EndNode)node;
                endNodeFound = true;
                if (endNode.getFrom() != null) continue;
                errors.add(new RuleFlowProcessValidationErrorImpl("End node has no incoming connection."));
                continue;
            }
            if (node instanceof RuleSetNode) {
                String ruleFlowGroup;
                RuleSetNode ruleSetNode = (RuleSetNode)node;
                if (ruleSetNode.getFrom() == null) {
                    errors.add(new RuleFlowProcessValidationErrorImpl("RuleSet node has no incoming connection."));
                }
                if (ruleSetNode.getTo() == null) {
                    errors.add(new RuleFlowProcessValidationErrorImpl("RuleSet node has no outgoing connection."));
                }
                if ((ruleFlowGroup = ruleSetNode.getRuleFlowGroup()) != null && !"".equals(ruleFlowGroup)) continue;
                errors.add(new RuleFlowProcessValidationErrorImpl("RuleSet node has no ruleflow-group specified."));
                continue;
            }
            if (node instanceof Split) {
                Split split = (Split)node;
                if (split.getType() == 0) {
                    errors.add(new RuleFlowProcessValidationErrorImpl("Split node has no type."));
                }
                if (split.getFrom() == null) {
                    errors.add(new RuleFlowProcessValidationErrorImpl("Split node has no incoming connection."));
                }
                if (split.getOutgoingConnections().size() < 2) {
                    errors.add(new RuleFlowProcessValidationErrorImpl("Split node does not have enough outgoing connections."));
                }
                if (split.getType() != 2 && split.getType() != 3) continue;
                Iterator it = split.getOutgoingConnections().iterator();
                while (it.hasNext()) {
                    Connection connection = (Connection)it.next();
                    if (split.getConstraint(connection) != null) continue;
                    errors.add(new RuleFlowProcessValidationErrorImpl("An outgoing connection of a split node has no constraint."));
                }
                continue;
            }
            if (node instanceof Join) {
                Join join = (Join)node;
                if (join.getType() == 0) {
                    errors.add(new RuleFlowProcessValidationErrorImpl("Join node has no type."));
                }
                if (join.getIncomingConnections().size() < 2) {
                    errors.add(new RuleFlowProcessValidationErrorImpl("Join node does not have enough incoming connections."));
                }
                if (join.getTo() != null) continue;
                errors.add(new RuleFlowProcessValidationErrorImpl("Join node has no outgoing connection."));
                continue;
            }
            if (!(node instanceof MilestoneNode)) continue;
            MilestoneNode milestone = (MilestoneNode)node;
            if (milestone.getFrom() == null) {
                errors.add(new RuleFlowProcessValidationErrorImpl("Milestone node has no incoming connection."));
            }
            if (milestone.getTo() == null) {
                errors.add(new RuleFlowProcessValidationErrorImpl("Milestone node has no outgoing connection."));
            }
            if (milestone.getConstraint() != null) continue;
            errors.add(new RuleFlowProcessValidationErrorImpl("A milestone node has no constraint."));
        }
        if (!startNodeFound) {
            errors.add(new RuleFlowProcessValidationErrorImpl("RuleFlow process has no start node."));
        }
        if (!endNodeFound) {
            errors.add(new RuleFlowProcessValidationErrorImpl("No end node found."));
        }
        Iterator it = process.getVariables().iterator();
        while (it.hasNext()) {
            Variable variable = (Variable)it.next();
            if (variable.getType() != null) continue;
            errors.add(new RuleFlowProcessValidationErrorImpl("A variable has no type."));
        }
        this.checkAllNodesConnectedToStart(process, errors);
        return errors.toArray(new RuleFlowProcessValidationError[errors.size()]);
    }

    private void checkAllNodesConnectedToStart(RuleFlowProcess process, List errors) {
        HashMap<Node, Boolean> processNodes = new HashMap<Node, Boolean>();
        Node[] nodes = process.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            processNodes.put(node, Boolean.FALSE);
        }
        StartNode start = process.getStart();
        if (start != null) {
            this.processNode(start, processNodes);
        }
        Iterator it = processNodes.keySet().iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!Boolean.FALSE.equals(processNodes.get(node))) continue;
            errors.add(new RuleFlowProcessValidationErrorImpl("A node is not connected to the start node."));
        }
    }

    private void processNode(Node node, Map nodes) {
        if (!nodes.containsKey(node)) {
            throw new IllegalStateException("A process node is connected with a node that does not belong to the process.");
        }
        Boolean prevValue = nodes.put(node, Boolean.TRUE);
        if (prevValue == Boolean.FALSE) {
            Iterator it = node.getOutgoingConnections().iterator();
            while (it.hasNext()) {
                Connection connection = (Connection)it.next();
                this.processNode(connection.getTo(), nodes);
            }
        }
    }
}

