/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.Arrays;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldExtractor;
import org.drools.spi.Restriction;

public class VariableRestriction
implements Restriction {
    private static final long serialVersionUID = 400L;
    private final Declaration declaration;
    private final Declaration[] requiredDeclarations;
    private final Evaluator evaluator;
    private final VariableContextEntry contextEntry;

    public VariableRestriction(FieldExtractor fieldExtractor, Declaration declaration, Evaluator evaluator) {
        this.declaration = declaration;
        this.requiredDeclarations = new Declaration[]{declaration};
        this.evaluator = evaluator;
        this.contextEntry = this.createContextEntry(this.evaluator, fieldExtractor);
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public boolean isAllowed(Extractor extractor, Object object, InternalWorkingMemory workingMemory) {
        return this.evaluator.evaluate(workingMemory, this.contextEntry.extractor, object, this.contextEntry.declaration.getExtractor(), object);
    }

    public boolean isAllowedCachedLeft(ContextEntry context, Object object) {
        return this.evaluator.evaluateCachedLeft(((VariableContextEntry)context).workingMemory, (VariableContextEntry)context, object);
    }

    public boolean isAllowedCachedRight(ReteTuple tuple, ContextEntry context) {
        return this.evaluator.evaluateCachedRight(((VariableContextEntry)context).workingMemory, (VariableContextEntry)context, tuple.get(this.declaration).getObject());
    }

    public String toString() {
        return "[VariableRestriction declaration=" + this.declaration + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.declaration == null ? 0 : this.declaration.hashCode());
        result = 31 * result + (this.evaluator == null ? 0 : this.evaluator.hashCode());
        result = 31 * result + this.requiredDeclarations[0].hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VariableRestriction other = (VariableRestriction)object;
        return this.declaration.equals(other.declaration) && this.evaluator.equals(other.evaluator) && Arrays.equals(this.requiredDeclarations, other.requiredDeclarations);
    }

    private final VariableContextEntry createContextEntry(Evaluator eval, FieldExtractor fieldExtractor) {
        if (Operator.MEMBEROF.equals(eval.getOperator()) || Operator.NOTMEMBEROF.equals(eval.getOperator())) {
            return new ObjectVariableContextEntry(fieldExtractor, this.declaration);
        }
        if (fieldExtractor.getValueType().isBoolean()) {
            return new BooleanVariableContextEntry(fieldExtractor, this.declaration);
        }
        if (fieldExtractor.getValueType().isFloatNumber()) {
            return new DoubleVariableContextEntry(fieldExtractor, this.declaration);
        }
        if (fieldExtractor.getValueType().isIntegerNumber()) {
            return new LongVariableContextEntry(fieldExtractor, this.declaration);
        }
        if (fieldExtractor.getValueType().isChar()) {
            return new CharVariableContextEntry(fieldExtractor, this.declaration);
        }
        return new ObjectVariableContextEntry(fieldExtractor, this.declaration);
    }

    public ContextEntry getContextEntry() {
        return this.contextEntry;
    }

    public static class BooleanVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = -7664012658143075200L;
        public boolean left;
        public boolean right;

        public BooleanVariableContextEntry(FieldExtractor extractor, Declaration declaration) {
            super(extractor, declaration);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, ReteTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
            this.left = !this.leftNull ? this.declaration.getExtractor().getBooleanValue(workingMemory, tuple.get(this.declaration).getObject()) : false;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
            this.right = !this.rightNull ? this.extractor.getBooleanValue(workingMemory, handle.getObject()) : false;
        }
    }

    public static class DoubleVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 400L;
        public double left;
        public double right;

        public DoubleVariableContextEntry(FieldExtractor extractor, Declaration declaration) {
            super(extractor, declaration);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, ReteTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
            this.left = !this.leftNull ? this.declaration.getExtractor().getDoubleValue(workingMemory, tuple.get(this.declaration).getObject()) : 0.0;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
            this.right = !this.rightNull ? this.extractor.getDoubleValue(workingMemory, handle.getObject()) : 0.0;
        }
    }

    public static class CharVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = -5316792696755228175L;
        public char left;
        public char right;

        public CharVariableContextEntry(FieldExtractor extractor, Declaration declaration) {
            super(extractor, declaration);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, ReteTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
            this.left = !this.leftNull ? this.declaration.getExtractor().getCharValue(workingMemory, tuple.get(this.declaration).getObject()) : (char)'\u0000';
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
            this.right = !this.rightNull ? this.extractor.getCharValue(workingMemory, handle.getObject()) : (char)'\u0000';
        }
    }

    public static class LongVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = -5316792696755228175L;
        public long left;
        public long right;

        public LongVariableContextEntry(FieldExtractor extractor, Declaration declaration) {
            super(extractor, declaration);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, ReteTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
            this.left = !this.leftNull ? this.declaration.getExtractor().getLongValue(workingMemory, tuple.get(this.declaration).getObject()) : 0L;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
            this.right = !this.rightNull ? this.extractor.getLongValue(workingMemory, handle.getObject()) : 0L;
        }
    }

    public static class ObjectVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 400L;
        public Object left;
        public Object right;

        public ObjectVariableContextEntry(FieldExtractor extractor, Declaration declaration) {
            super(extractor, declaration);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, ReteTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
            this.left = this.declaration.getExtractor().getValue(workingMemory, tuple.get(this.declaration).getObject());
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
            this.right = this.extractor.getValue(workingMemory, handle.getObject());
        }
    }

    public static abstract class VariableContextEntry
    implements ContextEntry {
        public FieldExtractor extractor;
        public Object object;
        public Declaration declaration;
        public ReteTuple reteTuple;
        public ContextEntry entry;
        public boolean leftNull;
        public boolean rightNull;
        public InternalWorkingMemory workingMemory;

        public VariableContextEntry(FieldExtractor extractor, Declaration declaration) {
            this.extractor = extractor;
            this.declaration = declaration;
        }

        public ContextEntry getNext() {
            return this.entry;
        }

        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        public FieldExtractor getFieldExtractor() {
            return this.extractor;
        }

        public Object getObject() {
            return this.object;
        }

        public ReteTuple getTuple() {
            return this.reteTuple;
        }

        public Declaration getVariableDeclaration() {
            return this.declaration;
        }

        public boolean isLeftNull() {
            return this.leftNull;
        }

        public boolean isRightNull() {
            return this.rightNull;
        }
    }
}

