/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.rule.Declaration;
import org.drools.rule.PatternSource;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.Constraint;
import org.drools.spi.Extractor;
import org.drools.spi.ObjectType;
import org.drools.spi.PatternExtractor;

public class Pattern
implements RuleConditionElement {
    private static final long serialVersionUID = 400L;
    private final ObjectType objectType;
    private List constraints = Collections.EMPTY_LIST;
    final Declaration declaration;
    private Map declarations;
    private final int index;
    private PatternSource source;
    private int offset;

    public Pattern(int index, ObjectType objectType) {
        this(index, index, objectType, null);
    }

    public Pattern(int index, ObjectType objectType, String identifier) {
        this(index, index, objectType, identifier);
    }

    public Pattern(int index, int offset, ObjectType objectType, String identifier) {
        this.index = index;
        this.offset = offset;
        this.objectType = objectType;
        if (identifier != null && !identifier.equals("")) {
            this.declaration = new Declaration(identifier, new PatternExtractor(objectType), this);
            this.declarations = new HashMap(2);
            this.declarations.put(this.declaration.getIdentifier(), this.declaration);
        } else {
            this.declaration = null;
        }
    }

    public Object clone() {
        String identifier = this.declaration != null ? this.declaration.getIdentifier() : null;
        Pattern clone = new Pattern(this.index, this.objectType, identifier);
        Iterator it = this.constraints.iterator();
        while (it.hasNext()) {
            Object constr = it.next();
            if (constr instanceof Declaration) {
                Declaration decl = (Declaration)constr;
                clone.addDeclaration(decl.getIdentifier(), decl.getExtractor());
                continue;
            }
            clone.addConstraint((Constraint)constr);
        }
        return clone;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public PatternSource getSource() {
        return this.source;
    }

    public void setSource(PatternSource source) {
        this.source = source;
    }

    public List getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public void addConstraint(Constraint constraint) {
        if (this.constraints == Collections.EMPTY_LIST) {
            this.constraints = new ArrayList(1);
        }
        this.constraints.add(constraint);
    }

    public Declaration addDeclaration(String identifier, Extractor extractor) {
        if (this.constraints == Collections.EMPTY_LIST) {
            this.constraints = new ArrayList(1);
        }
        Declaration declaration = new Declaration(identifier, extractor, this);
        this.constraints.add(declaration);
        if (this.declarations == null) {
            this.declarations = new HashMap(2);
        }
        this.declarations.put(declaration.getIdentifier(), declaration);
        return declaration;
    }

    public boolean isBound() {
        return this.declaration != null;
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public int getIndex() {
        return this.index;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Map getInnerDeclarations() {
        return this.declarations != null ? this.declarations : Collections.EMPTY_MAP;
    }

    public Map getOuterDeclarations() {
        return this.declarations != null ? this.declarations : Collections.EMPTY_MAP;
    }

    public Declaration resolveDeclaration(String identifier) {
        return this.declarations != null ? (Declaration)this.declarations.get(identifier) : null;
    }

    public String toString() {
        return "Pattern type='" + (this.objectType == null ? "null" : this.objectType.toString()) + "', index='" + this.index + "', offset='" + this.getOffset() + "', identifer='" + (this.declaration == null ? "" : this.declaration.toString()) + "'";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + ((Object)this.constraints).hashCode();
        result = 31 * result + (this.declaration == null ? 0 : this.declaration.hashCode());
        result = 31 * result + this.index;
        result = 31 * result + (this.objectType == null ? 0 : this.objectType.hashCode());
        result = 31 * result + this.offset;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Pattern other = (Pattern)object;
        if (!((Object)this.constraints).equals(other.constraints)) {
            return false;
        }
        if (this.declaration == null ? other.declaration != null : !this.declaration.equals(other.declaration)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (!this.objectType.equals(other.objectType)) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return this.source == null ? other.source == null : this.source.equals(other.source);
    }
}

