/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.Collections;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.WorkingMemory;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.spi.EvalExpression;
import org.drools.spi.Tuple;

public class EvalCondition
extends ConditionalElement {
    private static final long serialVersionUID = 400L;
    private EvalExpression expression;
    private final Declaration[] requiredDeclarations;
    private static final Declaration[] EMPTY_DECLARATIONS = new Declaration[0];

    public EvalCondition(Declaration[] requiredDeclarations) {
        this(null, requiredDeclarations);
    }

    public EvalCondition(EvalExpression eval, Declaration[] requiredDeclarations) {
        this.expression = eval;
        this.requiredDeclarations = requiredDeclarations == null ? EMPTY_DECLARATIONS : requiredDeclarations;
    }

    public EvalExpression getEvalExpression() {
        return this.expression;
    }

    public void setEvalExpression(EvalExpression expression) {
        this.expression = expression;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public boolean isAllowed(Tuple tuple, WorkingMemory workingMemory) {
        try {
            return this.expression.evaluate(tuple, this.requiredDeclarations, workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public Object clone() {
        EvalCondition eval = new EvalCondition(this.expression, this.requiredDeclarations);
        return eval;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != EvalCondition.class) {
            return false;
        }
        EvalCondition other = (EvalCondition)object;
        if (this.requiredDeclarations.length != other.requiredDeclarations.length) {
            return false;
        }
        int length = this.requiredDeclarations.length;
        for (int i = 0; i < length; ++i) {
            if (this.requiredDeclarations[i].getPattern().getOffset() != other.requiredDeclarations[i].getPattern().getOffset()) {
                return false;
            }
            if (this.requiredDeclarations[i].getExtractor().equals(other.requiredDeclarations[i].getExtractor())) continue;
            return false;
        }
        return this.expression.equals(other.expression);
    }

    public Map getInnerDeclarations() {
        return Collections.EMPTY_MAP;
    }

    public Map getOuterDeclarations() {
        return Collections.EMPTY_MAP;
    }

    public Declaration resolveDeclaration(String identifier) {
        return null;
    }
}

