/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.Arrays;
import java.util.HashSet;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.spi.Restriction;

public abstract class AbstractCompositeRestriction
implements Restriction {
    private static final long serialVersionUID = 400L;
    protected final Restriction[] restrictions;
    protected final CompositeContextEntry contextEntry;

    public AbstractCompositeRestriction(Restriction[] restriction) {
        this.restrictions = restriction;
        this.contextEntry = new CompositeContextEntry(this.restrictions);
    }

    public Declaration[] getRequiredDeclarations() {
        HashSet<Declaration> set = new HashSet<Declaration>();
        int ilength = this.restrictions.length;
        for (int i = 0; i < ilength; ++i) {
            Declaration[] declarations = this.restrictions[i].getRequiredDeclarations();
            int jlength = declarations.length;
            for (int j = 0; j < jlength; ++j) {
                set.add(declarations[j]);
            }
        }
        return set.toArray(new Declaration[set.size()]);
    }

    private static int hashCode(Object[] array) {
        int PRIME = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = 0; index < array.length; ++index) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
        }
        return result;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + AbstractCompositeRestriction.hashCode(this.restrictions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj instanceof AbstractCompositeRestriction) {
            return false;
        }
        AbstractCompositeRestriction other = (AbstractCompositeRestriction)obj;
        return Arrays.equals(this.restrictions, other.restrictions);
    }

    public ContextEntry getContextEntry() {
        return this.contextEntry;
    }

    public static class CompositeContextEntry
    implements ContextEntry {
        public ContextEntry[] contextEntries;
        private ContextEntry entry;

        public CompositeContextEntry(Restriction[] restrictions) {
            ContextEntry[] contextEntries = new ContextEntry[restrictions.length];
            for (int i = 0; i < restrictions.length; ++i) {
                contextEntries[i] = restrictions[i].getContextEntry();
            }
        }

        public ContextEntry getNext() {
            return this.entry;
        }

        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            int length = this.contextEntries.length;
            for (int i = 0; i < length; ++i) {
                this.contextEntries[i].updateFromFactHandle(workingMemory, handle);
            }
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, ReteTuple tuple) {
            int length = this.contextEntries.length;
            for (int i = 0; i < length; ++i) {
                this.contextEntries[i].updateFromTuple(workingMemory, tuple);
            }
        }
    }
}

