/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.Arrays;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.Constraint;
import org.drools.util.ArrayUtils;

public abstract class AbstractCompositeConstraint
implements AlphaNodeFieldConstraint,
BetaNodeFieldConstraint {
    protected AlphaNodeFieldConstraint[] alphaConstraints = new AlphaNodeFieldConstraint[0];
    protected BetaNodeFieldConstraint[] betaConstraints = new BetaNodeFieldConstraint[0];
    protected Declaration[] requiredDeclarations = new Declaration[0];

    public void addAlphaConstraint(AlphaNodeFieldConstraint constraint) {
        if (constraint != null) {
            AlphaNodeFieldConstraint[] tmp = this.alphaConstraints;
            this.alphaConstraints = new AlphaNodeFieldConstraint[tmp.length + 1];
            System.arraycopy(tmp, 0, this.alphaConstraints, 0, tmp.length);
            this.alphaConstraints[this.alphaConstraints.length - 1] = constraint;
            this.updateRequiredDeclarations(constraint);
        }
    }

    public void addBetaConstraint(BetaNodeFieldConstraint constraint) {
        if (constraint != null) {
            BetaNodeFieldConstraint[] tmp = this.betaConstraints;
            this.betaConstraints = new BetaNodeFieldConstraint[tmp.length + 1];
            System.arraycopy(tmp, 0, this.betaConstraints, 0, tmp.length);
            this.betaConstraints[this.betaConstraints.length - 1] = constraint;
            this.updateRequiredDeclarations(constraint);
        }
    }

    public void addConstraint(Constraint constraint) {
        if (constraint instanceof AlphaNodeFieldConstraint) {
            this.addAlphaConstraint((AlphaNodeFieldConstraint)constraint);
        }
        if (constraint instanceof BetaNodeFieldConstraint) {
            this.addBetaConstraint((BetaNodeFieldConstraint)constraint);
        }
    }

    private void updateRequiredDeclarations(Constraint constraint) {
        Declaration[] decs = constraint.getRequiredDeclarations();
        if (decs != null && decs.length > 0) {
            for (int i = 0; i < decs.length; ++i) {
                Declaration dec = decs[i];
                for (int j = 0; j < this.requiredDeclarations.length; ++j) {
                    if (!dec.equals(this.requiredDeclarations[j])) continue;
                    dec = null;
                    break;
                }
                if (dec == null) continue;
                Declaration[] tmp = this.requiredDeclarations;
                this.requiredDeclarations = new Declaration[tmp.length + 1];
                System.arraycopy(tmp, 0, this.requiredDeclarations, 0, tmp.length);
                this.requiredDeclarations[this.requiredDeclarations.length - 1] = dec;
            }
        }
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public ContextEntry getContextEntry() {
        return new MultiFieldConstraintContextEntry(this.betaConstraints);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + ArrayUtils.hashCode(this.alphaConstraints);
        result = 31 * result + ArrayUtils.hashCode(this.betaConstraints);
        result = 31 * result + ArrayUtils.hashCode(this.requiredDeclarations);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != AbstractCompositeConstraint.class) {
            return false;
        }
        AbstractCompositeConstraint other = (AbstractCompositeConstraint)object;
        return Arrays.equals(this.alphaConstraints, other.alphaConstraints) && Arrays.equals(this.betaConstraints, other.betaConstraints) && Arrays.equals(this.requiredDeclarations, other.requiredDeclarations);
    }

    protected static class MultiFieldConstraintContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = -612826751146514955L;
        public final ContextEntry[] contexts;
        public ContextEntry next;

        public MultiFieldConstraintContextEntry(BetaNodeFieldConstraint[] constraints) {
            this.contexts = new ContextEntry[constraints.length];
            for (int i = 0; i < this.contexts.length; ++i) {
                this.contexts[i] = constraints[i].getContextEntry();
            }
        }

        public ContextEntry getNext() {
            return this.next;
        }

        public void setNext(ContextEntry entry) {
            this.next = entry;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            for (int i = 0; i < this.contexts.length; ++i) {
                this.contexts[i].updateFromFactHandle(workingMemory, handle);
            }
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, ReteTuple tuple) {
            for (int i = 0; i < this.contexts.length; ++i) {
                this.contexts[i].updateFromTuple(workingMemory, tuple);
            }
        }
    }
}

