/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.TupleSource;
import org.drools.rule.RuleConditionElement;

public class BuildContext {
    private TupleSource tupleSource;
    private ObjectSource objectSource;
    private LinkedList objectType;
    private int currentPatternOffset;
    private InternalRuleBase rulebase;
    private InternalWorkingMemory[] workingMemories;
    private ReteooBuilder.IdGenerator idGenerator;
    private LinkedList buildstack;
    private List betaconstraints;
    private List alphaConstraints;

    public BuildContext(InternalRuleBase rulebase, ReteooBuilder.IdGenerator idGenerator) {
        this.rulebase = rulebase;
        this.workingMemories = this.rulebase.getWorkingMemories();
        this.idGenerator = idGenerator;
        this.objectType = new LinkedList();
        this.buildstack = new LinkedList();
        this.tupleSource = null;
        this.objectSource = null;
        this.currentPatternOffset = 0;
    }

    public int getCurrentPatternOffset() {
        return this.currentPatternOffset;
    }

    public void setCurrentPatternOffset(int currentPatternIndex) {
        this.currentPatternOffset = currentPatternIndex;
        this.syncObjectTypesWithPatternOffset();
    }

    public void syncObjectTypesWithPatternOffset() {
        while (this.objectType.size() > this.currentPatternOffset) {
            this.objectType.removeLast();
        }
    }

    public ObjectSource getObjectSource() {
        return this.objectSource;
    }

    public void setObjectSource(ObjectSource objectSource) {
        this.objectSource = objectSource;
    }

    public LinkedList getObjectType() {
        return this.objectType;
    }

    public void setObjectType(LinkedList objectType) {
        this.objectType = objectType;
    }

    public TupleSource getTupleSource() {
        return this.tupleSource;
    }

    public void setTupleSource(TupleSource tupleSource) {
        this.tupleSource = tupleSource;
    }

    public void incrementCurrentPatternOffset() {
        ++this.currentPatternOffset;
    }

    public void decrementCurrentPatternOffset() {
        --this.currentPatternOffset;
        this.syncObjectTypesWithPatternOffset();
    }

    public InternalRuleBase getRuleBase() {
        return this.rulebase;
    }

    public InternalWorkingMemory[] getWorkingMemories() {
        return this.workingMemories;
    }

    public int getNextId() {
        return this.idGenerator.getNextId();
    }

    public void releaseLastId() {
        this.idGenerator.releaseLastId();
    }

    public void push(RuleConditionElement rce) {
        this.buildstack.addLast(rce);
    }

    public RuleConditionElement pop() {
        return (RuleConditionElement)this.buildstack.removeLast();
    }

    public RuleConditionElement peek() {
        return (RuleConditionElement)this.buildstack.getLast();
    }

    public ListIterator stackIterator() {
        return this.buildstack.listIterator();
    }

    public List getBetaconstraints() {
        return this.betaconstraints;
    }

    public void setBetaconstraints(List betaconstraints) {
        this.betaconstraints = betaconstraints;
    }

    public int getNextSequence(String groupName) {
        Integer seq = (Integer)this.rulebase.getAgendaGroupRuleTotals().get(groupName);
        if (seq == null) {
            seq = new Integer(0);
        }
        Integer newSeq = new Integer(seq + 1);
        this.rulebase.getAgendaGroupRuleTotals().put(groupName, newSeq);
        return newSeq;
    }

    public List getAlphaConstraints() {
        return this.alphaConstraints;
    }

    public void setAlphaConstraints(List alphaConstraints) {
        this.alphaConstraints = alphaConstraints;
    }
}

