/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.drools.FactException;
import org.drools.RuleBaseConfiguration;
import org.drools.RuntimeDroolsException;
import org.drools.base.ShadowProxy;
import org.drools.base.ShadowProxyFactory;
import org.drools.common.BaseNode;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.facttemplates.Fact;
import org.drools.facttemplates.FactImpl;
import org.drools.objenesis.Objenesis;
import org.drools.objenesis.ObjenesisStd;
import org.drools.objenesis.instantiator.ObjectInstantiator;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.spi.PropagationContext;
import org.drools.util.Iterator;
import org.drools.util.ObjectHashMap;

public class Rete
extends ObjectSource
implements Serializable,
ObjectSink,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private final ObjectHashMap objectTypeNodes = new ObjectHashMap();
    private transient InternalRuleBase ruleBase;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Cloneable;
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public Rete(InternalRuleBase ruleBase) {
        super(0);
        this.ruleBase = ruleBase;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.ruleBase = ((DroolsObjectInputStream)stream).getRuleBase();
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectTypeConf ojectTypeConf;
        ObjectHashMap memory = (ObjectHashMap)workingMemory.getNodeMemory(this);
        Object object = handle.getObject();
        if (object instanceof FactImpl) {
            String key = ((Fact)object).getFactTemplate().getName();
            ojectTypeConf = (ObjectTypeConf)memory.get(key);
            if (ojectTypeConf == null) {
                ojectTypeConf = new ObjectTypeConf(null, this.ruleBase);
                memory.put(key, ojectTypeConf, false);
            }
        } else {
            Class<?> cls = null;
            cls = object instanceof ShadowProxy ? ((ShadowProxy)object).getShadowedObject().getClass() : object.getClass();
            ojectTypeConf = (ObjectTypeConf)memory.get(cls);
            if (ojectTypeConf == null) {
                ojectTypeConf = new ObjectTypeConf(cls, this.ruleBase);
                memory.put(cls, ojectTypeConf, false);
            }
            if (ojectTypeConf.isShadowEnabled()) {
                if (!(handle.getObject() instanceof ShadowProxy)) {
                    handle.setObject(ojectTypeConf.getShadow(handle.getObject()));
                    handle.setShadowFact(true);
                } else {
                    ((ShadowProxy)handle.getObject()).updateProxy();
                }
            }
        }
        ObjectTypeNode[] cachedNodes = ojectTypeConf.getObjectTypeNodes(object);
        int length = cachedNodes.length;
        for (int i = 0; i < length; ++i) {
            cachedNodes[i].assertObject(handle, context, workingMemory);
        }
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectHashMap memory = (ObjectHashMap)workingMemory.getNodeMemory(this);
        Object object = handle.getObject();
        ObjectTypeConf objectTypeConf = object instanceof ShadowProxy ? (ObjectTypeConf)memory.get(((ShadowProxy)object).getShadowedObject().getClass()) : (ObjectTypeConf)memory.get(object.getClass());
        ObjectTypeNode[] cachedNodes = objectTypeConf.getObjectTypeNodes(object);
        if (cachedNodes == null) {
            return;
        }
        for (int i = 0; i < cachedNodes.length; ++i) {
            cachedNodes[i].retractObject(handle, context, workingMemory);
        }
    }

    protected void addObjectSink(ObjectSink objectSink) {
        ObjectTypeNode node = (ObjectTypeNode)objectSink;
        this.objectTypeNodes.put(node.getObjectType(), node, true);
    }

    protected void removeObjectSink(ObjectSink objectSink) {
        this.objectTypeNodes.remove(objectSink);
    }

    public void attach() {
        throw new UnsupportedOperationException("cannot call attach() from the root Rete node");
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        throw new UnsupportedOperationException("cannot call attach() from the root Rete node");
    }

    public void remove(BaseNode node, InternalWorkingMemory[] workingMemories) {
        ObjectTypeNode objectTypeNode = (ObjectTypeNode)node;
        this.removeObjectSink(objectTypeNode);
        for (int i = 0; i < workingMemories.length; ++i) {
            workingMemories[i].clearNodeMemory((NodeMemory)((Object)node));
        }
    }

    public ObjectHashMap getObjectTypeNodes() {
        return this.objectTypeNodes;
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new ObjectHashMap();
    }

    public InternalRuleBase getRuleBase() {
        return this.ruleBase;
    }

    public int hashCode() {
        return this.objectTypeNodes.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Rete)) {
            return false;
        }
        Rete other = (Rete)object;
        return this.objectTypeNodes.equals(other.objectTypeNodes);
    }

    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectHashMap memory = (ObjectHashMap)workingMemory.getNodeMemory(this);
        Iterator it = memory.iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            ((ObjectTypeConf)entry.getValue()).resetCache();
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
        ObjectTypeNode node = (ObjectTypeNode)sink;
        it = workingMemory.getFactHandleMap().iterator();
        ObjectHashMap.ObjectEntry entry2 = (ObjectHashMap.ObjectEntry)it.next();
        while (entry2 != null) {
            InternalFactHandle handle = (InternalFactHandle)entry2.getValue();
            if (node.matches(handle.getObject())) {
                node.assertObject(handle, context, workingMemory);
            }
            entry2 = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    public static class ObjectTypeConf
    implements Serializable {
        private static final Objenesis OBJENESIS = new ObjenesisStd(false);
        private final Class cls;
        private transient InternalRuleBase ruleBase;
        private ObjectTypeNode[] objectTypeNodes;
        protected boolean shadowEnabled;
        protected Class shadowClass;
        protected transient ObjectInstantiator instantiator;

        public ObjectTypeConf(Class clazz, InternalRuleBase ruleBase) {
            this.cls = clazz;
            this.ruleBase = ruleBase;
            this.defineShadowProxyData(clazz);
        }

        private void defineShadowProxyData(Class clazz) {
            String pkgName;
            Rete rete = this.ruleBase.getRete();
            if (!this.ruleBase.getConfiguration().isShadowProxy() || clazz == null || !this.ruleBase.getConfiguration().isShadowed(clazz.getName())) {
                this.shadowEnabled = false;
                this.shadowClass = null;
                this.instantiator = null;
                return;
            }
            Package pkg = clazz.getPackage();
            String string = pkgName = pkg != null ? pkg.getName() : "";
            if ("org.drools.reteoo".equals(pkgName) || "org.drools.base".equals(pkgName)) {
                this.shadowEnabled = false;
                this.shadowClass = null;
                this.instantiator = null;
                return;
            }
            Class shadowClass = this.loadOrGenerateProxy(clazz, rete);
            if (shadowClass == null) {
                ObjectTypeNode[] nodes = this.getMatchingObjectTypes(clazz);
                Class shadowClassRoot = clazz;
                while (shadowClass == null && (shadowClassRoot = this.findAFeasibleSuperclassOrInterface(nodes, shadowClassRoot)) != null) {
                    shadowClass = this.loadOrGenerateProxy(shadowClassRoot, rete);
                }
            }
            if (shadowClass != null) {
                this.shadowClass = shadowClass;
                this.shadowEnabled = true;
                this.setInstantiator();
            }
        }

        private Class loadOrGenerateProxy(Class clazz, Rete rete) {
            Class<?> shadowClass;
            block4: {
                shadowClass = null;
                String shadowProxyName = ShadowProxyFactory.getProxyClassNameForClass(clazz);
                try {
                    shadowClass = rete.getRuleBase().getMapBackedClassLoader().loadClass(shadowProxyName);
                }
                catch (ClassNotFoundException cnfe) {
                    byte[] proxyBytes = ShadowProxyFactory.getProxyBytes(clazz);
                    if (proxyBytes == null) break block4;
                    rete.getRuleBase().getMapBackedClassLoader().addClass(shadowProxyName, proxyBytes);
                    try {
                        shadowClass = rete.getRuleBase().getMapBackedClassLoader().loadClass(shadowProxyName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Unable to find or generate the ShadowProxy implementation for '" + clazz + "'");
                    }
                }
            }
            return shadowClass;
        }

        private Class findAFeasibleSuperclassOrInterface(ObjectTypeNode[] nodes, Class clazz) {
            boolean isOk;
            Class<Object> ret = clazz.getSuperclass();
            boolean bl = ret != null && ret != (class$java$lang$Object == null ? (class$java$lang$Object = Rete.class$("java.lang.Object")) : class$java$lang$Object) ? true : (isOk = false);
            if (isOk) {
                for (int i = 0; isOk && ret != null && i < nodes.length; ++i) {
                    isOk = nodes[i].matchesClass(ret);
                }
            }
            if (!isOk) {
                Class<?>[] interfaces = clazz.getInterfaces();
                boolean notFound = true;
                isOk = interfaces.length > 0;
                for (int i = 0; notFound && i < interfaces.length; ++i) {
                    ret = interfaces[i];
                    isOk = interfaces[i] != (class$java$io$Serializable == null ? Rete.class$("java.io.Serializable") : class$java$io$Serializable) && interfaces[i] != (class$java$lang$Cloneable == null ? Rete.class$("java.lang.Cloneable") : class$java$lang$Cloneable) && interfaces[i] != (class$java$lang$Comparable == null ? Rete.class$("java.lang.Comparable") : class$java$lang$Comparable);
                    for (int j = 0; isOk && j < nodes.length; ++j) {
                        isOk = nodes[j].matchesClass(ret);
                    }
                    notFound = !isOk;
                }
                if (notFound) {
                    ret = null;
                }
            }
            return ret;
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.ruleBase = ((DroolsObjectInputStream)stream).getRuleBase();
        }

        private void setInstantiator() {
            this.instantiator = OBJENESIS.getInstantiatorOf(this.shadowClass);
        }

        public Object getShadow(Object fact) throws RuntimeDroolsException {
            ShadowProxy proxy = null;
            if (this.isShadowEnabled()) {
                try {
                    if ((class$java$util$Collection == null ? (class$java$util$Collection = Rete.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(this.shadowClass) || (class$java$util$Map == null ? (class$java$util$Map = Rete.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(this.shadowClass)) {
                        try {
                            proxy = (ShadowProxy)this.shadowClass.getConstructor(this.cls).newInstance(fact);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (proxy == null) {
                        if (this.instantiator == null) {
                            this.setInstantiator();
                        }
                        proxy = (ShadowProxy)this.instantiator.newInstance();
                    }
                    proxy.setShadowedObject(fact);
                }
                catch (Exception e) {
                    throw new RuntimeDroolsException("Error creating shadow fact for object: " + fact, e);
                }
            }
            return proxy;
        }

        public boolean isShadowEnabled() {
            return this.shadowEnabled;
        }

        public void resetCache() {
            this.objectTypeNodes = null;
            this.defineShadowProxyData(this.cls);
        }

        public ObjectTypeNode[] getObjectTypeNodes(Object object) {
            if (this.objectTypeNodes == null) {
                this.buildCache(object);
            }
            return this.objectTypeNodes;
        }

        private ObjectTypeNode[] getMatchingObjectTypes(Class clazz) throws FactException {
            ArrayList<ObjectTypeNode> cache = new ArrayList<ObjectTypeNode>();
            Iterator it = this.ruleBase.getRete().getObjectTypeNodes().newIterator();
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                ObjectTypeNode node = (ObjectTypeNode)entry.getValue();
                if (node.matchesClass(clazz)) {
                    cache.add(node);
                }
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
            return cache.toArray(new ObjectTypeNode[cache.size()]);
        }

        private void buildCache(Object object) throws FactException {
            ArrayList<ObjectTypeNode> cache = new ArrayList<ObjectTypeNode>();
            Iterator it = this.ruleBase.getRete().getObjectTypeNodes().newIterator();
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                ObjectTypeNode node = (ObjectTypeNode)entry.getValue();
                if (node.matches(object)) {
                    cache.add(node);
                }
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
            this.objectTypeNodes = cache.toArray(new ObjectTypeNode[cache.size()]);
        }
    }
}

