/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.common.BetaConstraints;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.spi.PropagationContext;
import org.drools.util.FactEntry;
import org.drools.util.Iterator;

public class NotNode
extends BetaNode {
    private static final long serialVersionUID = 400L;
    static int notAssertObject = 0;
    static int notAssertTuple = 0;

    public NotNode(int id, TupleSource leftInput, ObjectSource rightInput) {
        super(id, leftInput, rightInput, EmptyBetaConstraints.getInstance());
    }

    public NotNode(int id, TupleSource leftInput, ObjectSource rightInput, BetaConstraints joinNodeBinder) {
        super(id, leftInput, rightInput, joinNodeBinder);
    }

    public void assertTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (!workingMemory.isSequential()) {
            memory.getTupleMemory().add(leftTuple);
        }
        Iterator it = memory.getFactHandleMemory().iterator(leftTuple);
        this.constraints.updateFromTuple(workingMemory, leftTuple);
        int matches = 0;
        FactEntry entry = (FactEntry)it.next();
        while (entry != null) {
            InternalFactHandle handle = entry.getFactHandle();
            if (this.constraints.isAllowedCachedLeft(handle.getObject())) {
                ++matches;
            }
            entry = (FactEntry)it.next();
        }
        leftTuple.setMatches(matches);
        if (matches == 0) {
            this.sink.propagateAssertTuple(leftTuple, context, workingMemory);
        }
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getFactHandleMemory().add(handle);
        if (workingMemory.isSequential()) {
            return;
        }
        Iterator it = memory.getTupleMemory().iterator(handle);
        this.constraints.updateFromFactHandle(workingMemory, handle);
        ReteTuple tuple = (ReteTuple)it.next();
        while (tuple != null) {
            if (this.constraints.isAllowedCachedRight(tuple)) {
                int matches = tuple.getMatches();
                tuple.setMatches(matches + 1);
                if (matches == 0) {
                    this.sink.propagateRetractTuple(tuple, context, workingMemory);
                }
            }
            tuple = (ReteTuple)it.next();
        }
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (!memory.getFactHandleMemory().remove(handle)) {
            return;
        }
        Iterator it = memory.getTupleMemory().iterator(handle);
        this.constraints.updateFromFactHandle(workingMemory, handle);
        ReteTuple tuple = (ReteTuple)it.next();
        while (tuple != null) {
            if (this.constraints.isAllowedCachedRight(tuple)) {
                tuple.setMatches(tuple.getMatches() - 1);
                if (tuple.getMatches() == 0) {
                    this.sink.propagateAssertTuple(tuple, context, workingMemory);
                }
            }
            tuple = (ReteTuple)it.next();
        }
    }

    public void retractTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        ReteTuple tuple = memory.getTupleMemory().remove(leftTuple);
        if (tuple == null) {
            return;
        }
        if (tuple.getMatches() == 0) {
            this.sink.propagateRetractTuple(tuple, context, workingMemory);
        }
    }

    public void updateSink(TupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator tupleIter = memory.getTupleMemory().iterator();
        ReteTuple tuple = (ReteTuple)tupleIter.next();
        while (tuple != null) {
            if (tuple.getMatches() == 0) {
                sink.assertTuple(new ReteTuple(tuple), context, workingMemory);
            }
            tuple = (ReteTuple)tupleIter.next();
        }
    }

    public String toString() {
        ObjectSource source = this.rightInput;
        while (!(source instanceof ObjectTypeNode)) {
            source = source.objectSource;
        }
        return "[NotNode - " + ((ObjectTypeNode)source).getObjectType() + "]";
    }
}

