/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.FactException;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.PropagationContext;
import org.drools.util.FactEntry;
import org.drools.util.FactHashTable;
import org.drools.util.Iterator;

public class AlphaNode
extends ObjectSource
implements ObjectSinkNode,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private final AlphaNodeFieldConstraint constraint;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;

    public AlphaNode(int id, AlphaNodeFieldConstraint constraint, ObjectSource objectSource, boolean hasMemory, int alphaNodeHashingThreshold) {
        super(id, objectSource, alphaNodeHashingThreshold);
        this.constraint = constraint;
        this.setHasMemory(hasMemory);
    }

    public AlphaNodeFieldConstraint getConstraint() {
        return this.constraint;
    }

    public void attach() {
        this.objectSource.addObjectSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        this.setHasMemory(true);
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.objectSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) throws FactException {
        if (this.constraint.isAllowed(handle.getObject(), workingMemory)) {
            if (this.hasMemory() && !workingMemory.isSequential()) {
                FactHashTable memory = (FactHashTable)workingMemory.getNodeMemory(this);
                memory.add(handle, false);
            }
            this.sink.propagateAssertObject(handle, context, workingMemory);
        }
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        boolean propagate = true;
        if (this.hasMemory()) {
            FactHashTable memory = (FactHashTable)workingMemory.getNodeMemory(this);
            propagate = memory.remove(handle);
        } else {
            propagate = this.constraint.isAllowed(handle.getObject(), workingMemory);
        }
        if (propagate) {
            this.sink.propagateRetractObject(handle, context, workingMemory, true);
        }
    }

    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        FactHashTable memory = null;
        if (!this.hasMemory()) {
            this.objectSource.updateSink(sink, context, workingMemory);
        } else {
            memory = (FactHashTable)workingMemory.getNodeMemory(this);
            Iterator it = memory.iterator();
            FactEntry entry = (FactEntry)it.next();
            while (entry != null) {
                sink.assertObject(entry.getFactHandle(), context, workingMemory);
                entry = (FactEntry)it.next();
            }
        }
    }

    public void remove(BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeObjectSink((ObjectSink)((Object)node));
        }
        this.removeShare();
        if (!this.isInUse()) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                workingMemories[i].clearNodeMemory(this);
            }
        }
        this.objectSource.remove(this, workingMemories);
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new FactHashTable();
    }

    public String toString() {
        return "[AlphaNode(" + this.id + ") constraint=" + this.constraint + "]";
    }

    public int hashCode() {
        return this.objectSource.hashCode() * 17 + (this.constraint != null ? this.constraint.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AlphaNode)) {
            return false;
        }
        AlphaNode other = (AlphaNode)object;
        return this.objectSource.equals(other.objectSource) && this.constraint.equals(other.constraint);
    }

    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }
}

