/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.FactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.ObjectInsertedEvent;
import org.drools.event.ObjectRetractedEvent;
import org.drools.event.ObjectUpdatedEvent;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.spi.PropagationContext;

public class WorkingMemoryEventSupport
implements Serializable {
    private static final long serialVersionUID = -7572714148615479288L;
    private final List listeners = Collections.synchronizedList(new ArrayList());

    public void addEventListener(WorkingMemoryEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeEventListener(WorkingMemoryEventListener listener) {
        this.listeners.remove(listener);
    }

    public List getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void fireObjectInserted(PropagationContext propagationContext, FactHandle handle, Object object, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectInsertedEvent event = new ObjectInsertedEvent(workingMemory, propagationContext, handle, object);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((WorkingMemoryEventListener)this.listeners.get(i)).objectInserted(event);
        }
    }

    public void fireObjectUpdated(PropagationContext propagationContext, FactHandle handle, Object oldObject, Object object, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectUpdatedEvent event = new ObjectUpdatedEvent(workingMemory, propagationContext, handle, oldObject, object);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((WorkingMemoryEventListener)this.listeners.get(i)).objectUpdated(event);
        }
    }

    public void fireObjectRetracted(PropagationContext propagationContext, FactHandle handle, Object oldObject, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectRetractedEvent event = new ObjectRetractedEvent(workingMemory, propagationContext, handle, oldObject);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((WorkingMemoryEventListener)this.listeners.get(i)).objectRetracted(event);
        }
    }
}

