/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.ArrayList;
import org.drools.RuleBaseConfiguration;
import org.drools.base.evaluators.Operator;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.FactHandleMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleMemory;
import org.drools.rule.ContextEntry;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.util.AbstractHashTable;
import org.drools.util.FactHandleIndexHashTable;
import org.drools.util.FactHashTable;
import org.drools.util.FactList;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListEntry;
import org.drools.util.TupleHashTable;
import org.drools.util.TupleIndexHashTable;

public class TripleBetaConstraints
implements Serializable,
BetaConstraints {
    private static final long serialVersionUID = 400L;
    private final BetaNodeFieldConstraint constraint0;
    private final BetaNodeFieldConstraint constraint1;
    private final BetaNodeFieldConstraint constraint2;
    private final ContextEntry context0;
    private final ContextEntry context1;
    private final ContextEntry context2;
    private boolean indexed0;
    private boolean indexed1;
    private boolean indexed2;

    public TripleBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf) {
        this(constraints, conf, false);
    }

    public TripleBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf, boolean disableIndexing) {
        if (disableIndexing || !conf.isIndexLeftBetaMemory() && !conf.isIndexRightBetaMemory()) {
            this.indexed0 = false;
            this.indexed1 = false;
            this.indexed2 = false;
        } else {
            int depth = conf.getCompositeKeyDepth();
            boolean i0 = this.isIndexable(constraints[0]);
            boolean i1 = this.isIndexable(constraints[1]);
            boolean i2 = this.isIndexable(constraints[2]);
            if (depth >= 1 && i0) {
                this.indexed0 = true;
            }
            if (i1) {
                if (depth >= 1 && !this.indexed0) {
                    this.indexed0 = true;
                    this.swap(constraints, 1, 0);
                } else if (depth >= 2) {
                    this.indexed1 = true;
                }
            }
            if (i2) {
                if (depth >= 1 && !this.indexed0) {
                    this.indexed0 = true;
                    this.swap(constraints, 2, 0);
                } else if (depth >= 2 && this.indexed0 && !this.indexed1) {
                    this.indexed1 = true;
                    this.swap(constraints, 2, 1);
                } else if (depth >= 3) {
                    this.indexed2 = true;
                }
            }
        }
        this.constraint0 = constraints[0];
        this.context0 = this.constraint0.getContextEntry();
        this.constraint1 = constraints[1];
        this.context1 = this.constraint1.getContextEntry();
        this.constraint2 = constraints[2];
        this.context2 = this.constraint2.getContextEntry();
    }

    private void swap(BetaNodeFieldConstraint[] constraints, int p1, int p2) {
        BetaNodeFieldConstraint temp = constraints[p2];
        constraints[p2] = constraints[p1];
        constraints[p1] = temp;
    }

    private boolean isIndexable(BetaNodeFieldConstraint constraint) {
        if (constraint instanceof VariableConstraint) {
            VariableConstraint variableConstraint = (VariableConstraint)constraint;
            return variableConstraint.getEvaluator().getOperator() == Operator.EQUAL;
        }
        return false;
    }

    public void updateFromTuple(InternalWorkingMemory workingMemory, ReteTuple tuple) {
        this.context0.updateFromTuple(workingMemory, tuple);
        this.context1.updateFromTuple(workingMemory, tuple);
        this.context2.updateFromTuple(workingMemory, tuple);
    }

    public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
        this.context0.updateFromFactHandle(workingMemory, handle);
        this.context1.updateFromFactHandle(workingMemory, handle);
        this.context2.updateFromFactHandle(workingMemory, handle);
    }

    public boolean isAllowedCachedLeft(Object object) {
        return !(!this.indexed0 && !this.constraint0.isAllowedCachedLeft(this.context0, object) || !this.indexed1 && !this.constraint1.isAllowedCachedLeft(this.context1, object) || !this.indexed2 && !this.constraint2.isAllowedCachedLeft(this.context2, object));
    }

    public boolean isAllowedCachedRight(ReteTuple tuple) {
        return this.constraint0.isAllowedCachedRight(tuple, this.context0) && this.constraint1.isAllowedCachedRight(tuple, this.context1) && this.constraint2.isAllowedCachedRight(tuple, this.context2);
    }

    public boolean isIndexed() {
        return this.indexed0;
    }

    public boolean isEmpty() {
        return false;
    }

    public BetaMemory createBetaMemory(RuleBaseConfiguration conf) {
        BetaMemory memory;
        AbstractHashTable.FieldIndex index;
        VariableConstraint variableConstraint;
        ArrayList<AbstractHashTable.FieldIndex> list = new ArrayList<AbstractHashTable.FieldIndex>(2);
        if (this.indexed0) {
            variableConstraint = (VariableConstraint)this.constraint0;
            index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            list.add(index);
        }
        if (this.indexed1) {
            variableConstraint = (VariableConstraint)this.constraint1;
            index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            list.add(index);
        }
        if (this.indexed2) {
            variableConstraint = (VariableConstraint)this.constraint2;
            index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            list.add(index);
        }
        if (!list.isEmpty()) {
            AbstractHashTable.FieldIndex[] indexes = list.toArray(new AbstractHashTable.FieldIndex[list.size()]);
            AbstractHashTable tupleMemory = conf.isIndexLeftBetaMemory() ? new TupleIndexHashTable(indexes) : new TupleHashTable();
            FactHandleMemory factHandleMemory = conf.isIndexRightBetaMemory() ? new FactHandleIndexHashTable(indexes) : (conf.isSequential() ? new FactList() : new FactHashTable());
            memory = new BetaMemory((TupleMemory)((Object)(conf.isSequential() ? null : tupleMemory)), factHandleMemory);
        } else {
            memory = new BetaMemory(conf.isSequential() ? null : new TupleHashTable(), conf.isSequential() ? new FactList() : new FactHashTable());
        }
        return memory;
    }

    public int hashCode() {
        return this.constraint0.hashCode() ^ this.constraint1.hashCode() ^ this.constraint2.hashCode();
    }

    public LinkedList getConstraints() {
        LinkedList list = new LinkedList();
        list.add(new LinkedListEntry(this.constraint0));
        list.add(new LinkedListEntry(this.constraint1));
        list.add(new LinkedListEntry(this.constraint2));
        return list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TripleBetaConstraints other = (TripleBetaConstraints)object;
        if (this.constraint0 != other.constraint0 && !this.constraint0.equals(other.constraint0)) {
            return false;
        }
        if (this.constraint1 != other.constraint1 && !this.constraint1.equals(other.constraint1)) {
            return false;
        }
        return this.constraint2 == other.constraint2 || this.constraint2.equals(other.constraint2);
    }
}

