/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.base.DefaultKnowledgeHelper;
import org.drools.base.SequentialKnowledgeHelper;
import org.drools.common.ActivationGroupImpl;
import org.drools.common.ActivationGroupNode;
import org.drools.common.AgendaGroupFactory;
import org.drools.common.AgendaItem;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.common.RuleFlowGroupNode;
import org.drools.common.ScheduledAgendaItem;
import org.drools.common.Scheduler;
import org.drools.spi.Activation;
import org.drools.spi.ActivationGroup;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AgendaGroup;
import org.drools.spi.ConsequenceException;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.RuleFlowGroup;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListNode;

public class DefaultAgenda
implements Serializable,
InternalAgenda {
    private static final long serialVersionUID = 400L;
    private final InternalWorkingMemory workingMemory;
    private LinkedList scheduledActivations;
    private final Map agendaGroups;
    private final Map activationGroups;
    private final Map ruleFlowGroups;
    private final java.util.LinkedList focusStack;
    private AgendaGroup currentModule;
    private final AgendaGroup main;
    private AgendaGroupFactory agendaGroupFactory;
    private KnowledgeHelper knowledgeHelper;
    public int activeActivations;
    public int dormantActivations;

    public DefaultAgenda(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.knowledgeHelper = ((InternalRuleBase)this.workingMemory.getRuleBase()).getConfiguration().isSequential() ? new SequentialKnowledgeHelper(this.workingMemory) : new DefaultKnowledgeHelper(this.workingMemory);
        this.agendaGroups = new HashMap();
        this.activationGroups = new HashMap();
        this.ruleFlowGroups = new HashMap();
        this.focusStack = new java.util.LinkedList();
        this.agendaGroupFactory = ((InternalRuleBase)this.workingMemory.getRuleBase()).getConfiguration().getAgendaGroupFactory();
        this.main = this.agendaGroupFactory.createAgendaGroup("MAIN", (InternalRuleBase)this.workingMemory.getRuleBase());
        this.agendaGroups.put("MAIN", this.main);
        this.focusStack.add(this.main);
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public void scheduleItem(ScheduledAgendaItem item) {
        Scheduler.getInstance().scheduleAgendaItem(item);
        if (this.scheduledActivations == null) {
            this.scheduledActivations = new LinkedList();
        }
        this.scheduledActivations.add(item);
    }

    public void removeScheduleItem(ScheduledAgendaItem item) {
        this.scheduledActivations.remove(item);
        item.cancel();
    }

    public void addAgendaGroup(AgendaGroup agendaGroup) {
        this.agendaGroups.put(agendaGroup.getName(), agendaGroup);
    }

    public boolean setFocus(AgendaGroup agendaGroup) {
        if (this.focusStack.getLast() != agendaGroup) {
            ((InternalAgendaGroup)this.focusStack.getLast()).setActive(false);
            this.focusStack.add(agendaGroup);
            ((InternalAgendaGroup)agendaGroup).setActive(true);
            EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
            eventsupport.getAgendaEventSupport().fireAgendaGroupPushed(agendaGroup, this.workingMemory);
            return true;
        }
        return false;
    }

    public void setFocus(String name) {
        AgendaGroup agendaGroup = this.getAgendaGroup(name);
        this.setFocus(agendaGroup);
    }

    public AgendaGroup getFocus() {
        return (AgendaGroup)this.focusStack.getLast();
    }

    public AgendaGroup getNextFocus() {
        boolean empty;
        InternalAgendaGroup agendaGroup = null;
        while ((empty = (agendaGroup = (InternalAgendaGroup)this.focusStack.getLast()).isEmpty()) && this.focusStack.size() > 1) {
            agendaGroup.setActive(false);
            this.focusStack.removeLast();
            EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
            eventsupport.getAgendaEventSupport().fireAgendaGroupPopped(agendaGroup, this.workingMemory);
        }
        agendaGroup = empty ? null : agendaGroup;
        if (agendaGroup != null) {
            agendaGroup.setActive(true);
        }
        return agendaGroup;
    }

    public void setCurrentAgendaGroup(AgendaGroup agendaGroup) {
        this.currentModule = agendaGroup;
    }

    public AgendaGroup getCurrentAgendaGroup() {
        return this.currentModule;
    }

    public AgendaGroup getAgendaGroup(String name) {
        AgendaGroup agendaGroup = (AgendaGroup)this.agendaGroups.get(name);
        if (agendaGroup == null) {
            agendaGroup = this.agendaGroupFactory.createAgendaGroup(name, (InternalRuleBase)this.workingMemory.getRuleBase());
            this.addAgendaGroup(agendaGroup);
        }
        return agendaGroup;
    }

    public AgendaGroup[] getAgendaGroups() {
        return this.agendaGroups.values().toArray(new AgendaGroup[this.agendaGroups.size()]);
    }

    public AgendaGroup[] getStack() {
        return this.focusStack.toArray(new AgendaGroup[this.focusStack.size()]);
    }

    public ActivationGroup getActivationGroup(String name) {
        ActivationGroupImpl activationGroup = (ActivationGroupImpl)this.activationGroups.get(name);
        if (activationGroup == null) {
            activationGroup = new ActivationGroupImpl(name);
            this.activationGroups.put(name, activationGroup);
        }
        return activationGroup;
    }

    public RuleFlowGroup getRuleFlowGroup(String name) {
        RuleFlowGroup ruleFlowGroup = (RuleFlowGroup)this.ruleFlowGroups.get(name);
        if (ruleFlowGroup == null) {
            ruleFlowGroup = new RuleFlowGroupImpl(name);
            ((InternalRuleFlowGroup)ruleFlowGroup).setWorkingMemory((InternalWorkingMemory)this.getWorkingMemory());
            this.ruleFlowGroups.put(name, ruleFlowGroup);
        }
        return ruleFlowGroup;
    }

    public void activateRuleFlowGroup(String name) {
        ((InternalRuleFlowGroup)this.getRuleFlowGroup(name)).setActive(true);
    }

    public void deactivateRuleFlowGroup(String name) {
        ((InternalRuleFlowGroup)this.getRuleFlowGroup(name)).setActive(false);
    }

    public int focusStackSize() {
        int size = 0;
        Iterator iterator = this.focusStack.iterator();
        while (iterator.hasNext()) {
            AgendaGroup group = (AgendaGroup)iterator.next();
            size += group.size();
        }
        return size;
    }

    public int agendaSize() {
        int size = 0;
        Iterator iterator = this.agendaGroups.values().iterator();
        while (iterator.hasNext()) {
            AgendaGroup group = (AgendaGroup)iterator.next();
            size += group.size();
        }
        return size;
    }

    public Activation[] getActivations() {
        ArrayList<Activation> list = new ArrayList<Activation>();
        Iterator it = this.agendaGroups.values().iterator();
        while (it.hasNext()) {
            AgendaGroup group = (AgendaGroup)it.next();
            list.addAll(Arrays.asList(group.getActivations()));
        }
        return list.toArray(new Activation[list.size()]);
    }

    public Activation[] getScheduledActivations() {
        ArrayList<LinkedListNode> list = new ArrayList<LinkedListNode>(this.scheduledActivations.size());
        for (LinkedListNode node = this.scheduledActivations.getFirst(); node != null; node = node.getNext()) {
            list.add(node);
        }
        return list.toArray(new Activation[list.size()]);
    }

    public void clearAgenda() {
        Iterator agendaGroupIterator = this.agendaGroups.values().iterator();
        while (agendaGroupIterator.hasNext()) {
            AgendaGroup group = (AgendaGroup)agendaGroupIterator.next();
            this.clearAgendaGroup(group);
        }
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        if (this.scheduledActivations != null && !this.scheduledActivations.isEmpty()) {
            ScheduledAgendaItem item = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            while (item != null) {
                item.remove();
                eventsupport.getAgendaEventSupport().fireActivationCancelled(item, this.workingMemory);
                item = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            }
        }
    }

    public void clearAgendaGroup(String name) {
        AgendaGroup agendaGroup = (AgendaGroup)this.agendaGroups.get(name);
        if (agendaGroup != null) {
            this.clearAgendaGroup(agendaGroup);
        }
    }

    public void clearAgendaGroup(AgendaGroup agendaGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        Activation[] queueable = ((InternalAgendaGroup)agendaGroup).getQueue();
        int length = queueable.length;
        for (int i = 0; i < length; ++i) {
            AgendaItem item = (AgendaItem)queueable[i];
            if (item == null) continue;
            item.setActivated(false);
            if (item.getActivationGroupNode() != null) {
                item.getActivationGroupNode().getActivationGroup().removeActivation(item);
            }
            if (item.getRuleFlowGroupNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = item.getRuleFlowGroupNode().getRuleFlowGroup();
                ruleFlowGroup.removeActivation(item);
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled(item, this.workingMemory);
        }
        ((InternalAgendaGroup)agendaGroup).clear();
    }

    public void clearActivationGroup(String name) {
        ActivationGroup activationGroup = (ActivationGroup)this.activationGroups.get(name);
        if (activationGroup != null) {
            this.clearActivationGroup(activationGroup);
        }
    }

    public void clearActivationGroup(ActivationGroup activationGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        Iterator it = activationGroup.iterator();
        while (it.hasNext()) {
            ActivationGroupNode node = (ActivationGroupNode)it.next();
            Activation activation = node.getActivation();
            activation.setActivationGroupNode(null);
            if (!activation.isActivated()) continue;
            activation.setActivated(false);
            activation.remove();
            if (activation.getRuleFlowGroupNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = activation.getRuleFlowGroupNode().getRuleFlowGroup();
                ruleFlowGroup.removeActivation(activation);
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled(activation, this.workingMemory);
        }
        activationGroup.clear();
    }

    public void clearRuleFlowGroup(String name) {
        RuleFlowGroup ruleFlowGrlup = (RuleFlowGroup)this.ruleFlowGroups.get(name);
        if (ruleFlowGrlup != null) {
            this.clearRuleFlowGroup(ruleFlowGrlup);
        }
    }

    public void clearRuleFlowGroup(RuleFlowGroup ruleFlowGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        Iterator it = ruleFlowGroup.iterator();
        while (it.hasNext()) {
            RuleFlowGroupNode node = (RuleFlowGroupNode)it.next();
            AgendaItem item = (AgendaItem)node.getActivation();
            if (item != null) {
                item.setActivated(false);
                item.remove();
                if (item.getActivationGroupNode() != null) {
                    item.getActivationGroupNode().getActivationGroup().removeActivation(item);
                }
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled(item, this.workingMemory);
        }
        ((InternalRuleFlowGroup)ruleFlowGroup).clear();
        if (ruleFlowGroup.isActive() && ruleFlowGroup.isAutoDeactivate()) {
            RuleFlowGroupImpl.DeactivateCallback action = new RuleFlowGroupImpl.DeactivateCallback((InternalRuleFlowGroup)ruleFlowGroup);
            this.workingMemory.queueWorkingMemoryAction(action);
        }
    }

    public boolean fireNextItem(AgendaFilter filter) throws ConsequenceException {
        InternalAgendaGroup group = (InternalAgendaGroup)this.getNextFocus();
        if (group == null) {
            return false;
        }
        AgendaItem item = (AgendaItem)group.getNext();
        if (item == null) {
            return false;
        }
        if (filter == null || filter.accept(item)) {
            this.fireActivation(item);
        }
        return true;
    }

    public synchronized void fireActivation(Activation activation) throws ConsequenceException {
        this.increaseDormantActivations();
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        eventsupport.getAgendaEventSupport().fireBeforeActivationFired(activation, this.workingMemory);
        if (activation.getActivationGroupNode() != null) {
            ActivationGroup activationGroup = activation.getActivationGroupNode().getActivationGroup();
            activationGroup.removeActivation(activation);
            this.clearActivationGroup(activationGroup);
        }
        activation.setActivated(false);
        try {
            this.knowledgeHelper.setActivation(activation);
            activation.getRule().getConsequence().evaluate(this.knowledgeHelper, this.workingMemory);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConsequenceException(e, activation.getRule());
        }
        if (activation.getRuleFlowGroupNode() != null) {
            InternalRuleFlowGroup ruleFlowGroup = activation.getRuleFlowGroupNode().getRuleFlowGroup();
            ruleFlowGroup.removeActivation(activation);
        }
        eventsupport.getAgendaEventSupport().fireAfterActivationFired(activation, this.workingMemory);
    }

    public void increaseActiveActivations() {
        ++this.activeActivations;
    }

    public void decreaseActiveActivations() {
        --this.activeActivations;
    }

    public void increaseDormantActivations() {
        --this.activeActivations;
        ++this.dormantActivations;
    }

    public void decreaseDormantActivations() {
        --this.dormantActivations;
    }

    public int getActiveActivations() {
        return this.activeActivations;
    }

    public int getDormantActivations() {
        return this.dormantActivations;
    }
}

