/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.BaseMemberOfEvaluator;
import org.drools.base.evaluators.BaseNotMemberOfEvaluator;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;

public class ShortFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = -1295210800055648796L;
    private static EvaluatorFactory INSTANCE = new ShortFactory();

    private ShortFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ShortFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return ShortEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return ShortNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS) {
            return ShortLessEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS_OR_EQUAL) {
            return ShortLessOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER) {
            return ShortGreaterEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER_OR_EQUAL) {
            return ShortGreaterOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return ShortMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return ShortNotMemberOfEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for ShortEvaluator");
    }

    static class ShortNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ShortNotMemberOfEvaluator();

        private ShortNotMemberOfEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.NOTMEMBEROF);
        }

        public String toString() {
            return "Short not memberOf";
        }
    }

    static class ShortMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ShortMemberOfEvaluator();

        private ShortMemberOfEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.MEMBEROF);
        }

        public String toString() {
            return "Short memberOf";
        }
    }

    static class ShortGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new ShortGreaterOrEqualEvaluator();

        private ShortGreaterOrEqualEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getShortValue(workingMemory, object1) >= object2.getShortValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right >= (long)context.declaration.getExtractor().getShortValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getShortValue(workingMemory, right) >= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getShortValue(workingMemory, object1) >= extractor2.getShortValue(workingMemory, object2);
        }

        public String toString() {
            return "Short >=";
        }
    }

    static class ShortGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new ShortGreaterEvaluator();

        private ShortGreaterEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getShortValue(workingMemory, object1) > object2.getShortValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right > (long)context.declaration.getExtractor().getShortValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getShortValue(workingMemory, right) > ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getShortValue(workingMemory, object1) > extractor2.getShortValue(workingMemory, object2);
        }

        public String toString() {
            return "Short >";
        }
    }

    static class ShortLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new ShortLessOrEqualEvaluator();

        private ShortLessOrEqualEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getShortValue(workingMemory, object1) <= object2.getShortValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right <= (long)context.declaration.getExtractor().getShortValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getShortValue(workingMemory, right) <= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getShortValue(workingMemory, object1) <= extractor2.getShortValue(workingMemory, object2);
        }

        public String toString() {
            return "Boolean <=";
        }
    }

    static class ShortLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new ShortLessEvaluator();

        private ShortLessEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getShortValue(workingMemory, object1) < object2.getShortValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right < (long)context.declaration.getExtractor().getShortValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getShortValue(workingMemory, right) < ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getShortValue(workingMemory, object1) < extractor2.getShortValue(workingMemory, object2);
        }

        public String toString() {
            return "Short <";
        }
    }

    static class ShortNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new ShortNotEqualEvaluator();

        private ShortNotEqualEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getShortValue(workingMemory, object1) != object2.getShortValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return (long)context.declaration.getExtractor().getShortValue(workingMemory, left) != ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).left != (long)context.extractor.getShortValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return !extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return true;
            }
            return extractor1.getShortValue(workingMemory, object1) != extractor2.getShortValue(workingMemory, object2);
        }

        public String toString() {
            return "Short !=";
        }
    }

    static class ShortEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new ShortEqualEvaluator();

        private ShortEqualEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getShortValue(workingMemory, object1) == object2.getShortValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return (long)context.declaration.getExtractor().getShortValue(workingMemory, left) == ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).left == (long)context.extractor.getShortValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return false;
            }
            return extractor1.getShortValue(workingMemory, object1) == extractor2.getShortValue(workingMemory, object2);
        }

        public String toString() {
            return "Short ==";
        }
    }
}

