/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.util.Collection;
import org.drools.base.BaseEvaluator;
import org.drools.base.ShadowProxy;
import org.drools.base.ValueType;
import org.drools.base.evaluators.BaseMemberOfEvaluator;
import org.drools.base.evaluators.BaseNotMemberOfEvaluator;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;

public class ObjectFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = -8547142029512452551L;
    private static EvaluatorFactory INSTANCE = new ObjectFactory();

    private ObjectFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ObjectFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return ObjectEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return ObjectNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS) {
            return ObjectLessEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS_OR_EQUAL) {
            return ObjectLessOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER) {
            return ObjectGreaterEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER_OR_EQUAL) {
            return ObjectGreaterOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.CONTAINS) {
            return ObjectContainsEvaluator.INSTANCE;
        }
        if (operator == Operator.EXCLUDES) {
            return ObjectExcludesEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_CONTAINS) {
            return ObjectExcludesEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return ObjectMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return ObjectNotMemberOfEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for ObjectEvaluator");
    }

    static class ObjectNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectNotMemberOfEvaluator();

        private ObjectNotMemberOfEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.NOTMEMBEROF);
        }

        public String toString() {
            return "Object not memberOf";
        }
    }

    static class ObjectMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectMemberOfEvaluator();

        private ObjectMemberOfEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.MEMBEROF);
        }

        public String toString() {
            return "Object memberOf";
        }
    }

    static class ObjectExcludesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectExcludesEvaluator();

        private ObjectExcludesEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.EXCLUDES);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value = object2.getValue();
            Collection col = (Collection)extractor.getValue(workingMemory, object1);
            return !col.contains(value);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Collection col = (Collection)((VariableRestriction.ObjectVariableContextEntry)context).right;
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            return !col.contains(value);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            Collection col = (Collection)context.extractor.getValue(workingMemory, right);
            return !col.contains(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value = extractor2.getValue(workingMemory, object2);
            Collection col = (Collection)extractor1.getValue(workingMemory, object1);
            return !col.contains(value);
        }

        public String toString() {
            return "Object excludes";
        }
    }

    static class ObjectContainsEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectContainsEvaluator();

        private ObjectContainsEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.CONTAINS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value = object2.getValue();
            Collection col = (Collection)extractor.getValue(workingMemory, object1);
            return col == null ? false : col.contains(value);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            Collection col = (Collection)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return col == null ? false : col.contains(value);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            Collection col = (Collection)context.extractor.getValue(workingMemory, right);
            return col == null ? false : col.contains(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value = extractor2.getValue(workingMemory, object2);
            Collection col = (Collection)extractor1.getValue(workingMemory, object1);
            return col == null ? false : col.contains(value);
        }

        public String toString() {
            return "Object contains";
        }
    }

    static class ObjectGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectGreaterOrEqualEvaluator();

        private ObjectGreaterOrEqualEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor.getValue(workingMemory, object1);
            return comp.compareTo(object2.getValue()) >= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Comparable comp = (Comparable)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comp.compareTo(context.declaration.getExtractor().getValue(workingMemory, left)) >= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Comparable comp = (Comparable)context.extractor.getValue(workingMemory, right);
            return comp.compareTo(((VariableRestriction.ObjectVariableContextEntry)context).left) >= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor1.getValue(workingMemory, object1);
            return comp.compareTo(extractor2.getValue(workingMemory, object2)) >= 0;
        }

        public String toString() {
            return "Object >=";
        }
    }

    static class ObjectGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectGreaterEvaluator();

        private ObjectGreaterEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor.getValue(workingMemory, object1);
            return comp.compareTo(object2.getValue()) > 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Comparable comp = (Comparable)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comp.compareTo(context.declaration.getExtractor().getValue(workingMemory, left)) > 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Comparable comp = (Comparable)context.extractor.getValue(workingMemory, right);
            return comp.compareTo(((VariableRestriction.ObjectVariableContextEntry)context).left) > 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor1.getValue(workingMemory, object1);
            return comp.compareTo(extractor2.getValue(workingMemory, object2)) > 0;
        }

        public String toString() {
            return "Object >";
        }
    }

    static class ObjectLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectLessOrEqualEvaluator();

        private ObjectLessOrEqualEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor.getValue(workingMemory, object1);
            return comp.compareTo(object2.getValue()) <= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Comparable comp = (Comparable)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comp.compareTo(context.declaration.getExtractor().getValue(workingMemory, left)) <= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Comparable comp = (Comparable)context.extractor.getValue(workingMemory, right);
            return comp.compareTo(((VariableRestriction.ObjectVariableContextEntry)context).left) <= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor1.getValue(workingMemory, object1);
            return comp.compareTo(extractor2.getValue(workingMemory, object2)) <= 0;
        }

        public String toString() {
            return "Object <=";
        }
    }

    static class ObjectLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectLessEvaluator();

        private ObjectLessEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor.getValue(workingMemory, object1);
            return comp.compareTo(object2.getValue()) < 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Comparable comp = (Comparable)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comp.compareTo(context.declaration.getExtractor().getValue(workingMemory, left)) < 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Comparable comp = (Comparable)context.extractor.getValue(workingMemory, right);
            return comp.compareTo(((VariableRestriction.ObjectVariableContextEntry)context).left) < 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor1.getValue(workingMemory, object1);
            return comp.compareTo(extractor2.getValue(workingMemory, object2)) < 0;
        }

        public String toString() {
            return "Object <";
        }
    }

    static class ObjectNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectNotEqualEvaluator();

        private ObjectNotEqualEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 != null;
            }
            if (value2 != null && value2 instanceof ShadowProxy) {
                return !value2.equals(value1);
            }
            return !value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right != null;
            }
            if (((VariableRestriction.ObjectVariableContextEntry)context).right != null && ((VariableRestriction.ObjectVariableContextEntry)context).right instanceof ShadowProxy) {
                return !((VariableRestriction.ObjectVariableContextEntry)context).right.equals(value);
            }
            return !value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value != null;
            }
            if (value != null && value instanceof ShadowProxy) {
                return !value.equals(((VariableRestriction.ObjectVariableContextEntry)context).left);
            }
            return !((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 != null;
            }
            if (value2 != null && value2 instanceof ShadowProxy) {
                return !value2.equals(value1);
            }
            return !value1.equals(value2);
        }

        public String toString() {
            return "Object !=";
        }
    }

    static class ObjectEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectEqualEvaluator();

        private ObjectEqualEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 == null;
            }
            if (value2 != null && value2 instanceof ShadowProxy) {
                return value2.equals(value1);
            }
            return value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right == null;
            }
            if (((VariableRestriction.ObjectVariableContextEntry)context).right != null && ((VariableRestriction.ObjectVariableContextEntry)context).right instanceof ShadowProxy) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right.equals(value);
            }
            return value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value == null;
            }
            if (value != null && value instanceof ShadowProxy) {
                return value.equals(((VariableRestriction.ObjectVariableContextEntry)context).left);
            }
            return ((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            if (value2 != null && value2 instanceof ShadowProxy) {
                return value2.equals(value1);
            }
            return value1.equals(value2);
        }

        public String toString() {
            return "Object ==";
        }
    }
}

