/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.BaseMemberOfEvaluator;
import org.drools.base.evaluators.BaseNotMemberOfEvaluator;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;

public class IntegerFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = -6863552870087722275L;
    private static EvaluatorFactory INSTANCE = new IntegerFactory();

    private IntegerFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IntegerFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return IntegerEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return IntegerNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS) {
            return IntegerLessEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS_OR_EQUAL) {
            return IntegerLessOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER) {
            return IntegerGreaterEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER_OR_EQUAL) {
            return IntegerGreaterOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return IntegerMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return IntegerNotMemberOfEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for IntegerEvaluator");
    }

    static class IntegerNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerNotMemberOfEvaluator();

        private IntegerNotMemberOfEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.NOTMEMBEROF);
        }

        public String toString() {
            return "Integer not memberOf";
        }
    }

    static class IntegerMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerMemberOfEvaluator();

        private IntegerMemberOfEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.MEMBEROF);
        }

        public String toString() {
            return "Integer memberOf";
        }
    }

    static class IntegerGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new IntegerGreaterOrEqualEvaluator();

        private IntegerGreaterOrEqualEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getIntValue(workingMemory, object1) >= object2.getIntValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right >= (long)context.declaration.getExtractor().getIntValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getIntValue(workingMemory, right) >= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getIntValue(workingMemory, object1) >= extractor2.getIntValue(workingMemory, object2);
        }

        public String toString() {
            return "Integer >=";
        }
    }

    static class IntegerGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerGreaterEvaluator();

        private IntegerGreaterEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getIntValue(workingMemory, object1) > object2.getIntValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right > (long)context.declaration.getExtractor().getIntValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getIntValue(workingMemory, right) > ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getIntValue(workingMemory, object1) > extractor2.getIntValue(workingMemory, object2);
        }

        public String toString() {
            return "Integer >";
        }
    }

    static class IntegerLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerLessOrEqualEvaluator();

        private IntegerLessOrEqualEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getIntValue(workingMemory, object1) <= object2.getIntValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right <= (long)context.declaration.getExtractor().getIntValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getIntValue(workingMemory, right) <= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getIntValue(workingMemory, object1) <= extractor2.getIntValue(workingMemory, object2);
        }

        public String toString() {
            return "Integer <=";
        }
    }

    static class IntegerLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerLessEvaluator();

        private IntegerLessEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getIntValue(workingMemory, object1) < object2.getIntValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right < (long)context.declaration.getExtractor().getIntValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getIntValue(workingMemory, right) < ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getIntValue(workingMemory, object1) < extractor2.getIntValue(workingMemory, object2);
        }

        public String toString() {
            return "Integer <";
        }
    }

    static class IntegerNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerNotEqualEvaluator();

        private IntegerNotEqualEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getIntValue(workingMemory, object1) != object2.getIntValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return (long)context.declaration.getExtractor().getIntValue(workingMemory, left) != ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object object2) {
            if (context.extractor.isNullValue(workingMemory, object2)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return (long)context.extractor.getIntValue(workingMemory, object2) != ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return !extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return true;
            }
            return extractor1.getIntValue(workingMemory, object1) != extractor2.getIntValue(workingMemory, object2);
        }

        public String toString() {
            return "Integer !=";
        }
    }

    static class IntegerEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerEqualEvaluator();

        private IntegerEqualEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getIntValue(workingMemory, object1) == object2.getIntValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return (long)context.declaration.getExtractor().getIntValue(workingMemory, left) == ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object object2) {
            if (context.extractor.isNullValue(workingMemory, object2)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return (long)context.extractor.getIntValue(workingMemory, object2) == ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return false;
            }
            return extractor1.getIntValue(workingMemory, object1) == extractor2.getIntValue(workingMemory, object2);
        }

        public String toString() {
            return "Integer ==";
        }
    }
}

