/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.BaseMemberOfEvaluator;
import org.drools.base.evaluators.BaseNotMemberOfEvaluator;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;

public class CharacterFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = -8006570416583057447L;
    private static EvaluatorFactory INSTANCE = new CharacterFactory();

    private CharacterFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CharacterFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return CharacterEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return CharacterNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS) {
            return CharacterLessEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS_OR_EQUAL) {
            return CharacterLessOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER) {
            return CharacterGreaterEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER_OR_EQUAL) {
            return CharacterGreaterOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return CharacterMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return CharacterNotMemberOfEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for CharacterEvaluator");
    }

    static class CharacterNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterNotMemberOfEvaluator();

        private CharacterNotMemberOfEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.NOTMEMBEROF);
        }

        public String toString() {
            return "Character not memberOf";
        }
    }

    static class CharacterMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterMemberOfEvaluator();

        private CharacterMemberOfEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.MEMBEROF);
        }

        public String toString() {
            return "Character memberOf";
        }
    }

    static class CharacterGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new CharacterGreaterOrEqualEvaluator();

        private CharacterGreaterOrEqualEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getCharValue(workingMemory, object1) >= object2.getCharValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.CharVariableContextEntry)context).right >= context.declaration.getExtractor().getCharValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getCharValue(workingMemory, right) >= ((VariableRestriction.CharVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getCharValue(workingMemory, object1) >= extractor2.getCharValue(workingMemory, object2);
        }

        public String toString() {
            return "Character >=";
        }
    }

    static class CharacterGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterGreaterEvaluator();

        private CharacterGreaterEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getCharValue(workingMemory, object1) > object2.getCharValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.CharVariableContextEntry)context).right > context.declaration.getExtractor().getCharValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getCharValue(workingMemory, right) > ((VariableRestriction.CharVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getCharValue(workingMemory, object1) > extractor2.getCharValue(workingMemory, object2);
        }

        public String toString() {
            return "Character >";
        }
    }

    static class CharacterLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterLessOrEqualEvaluator();

        private CharacterLessOrEqualEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getCharValue(workingMemory, object1) <= object2.getCharValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.CharVariableContextEntry)context).right <= context.declaration.getExtractor().getCharValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getCharValue(workingMemory, right) <= ((VariableRestriction.CharVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getCharValue(workingMemory, object1) <= extractor2.getCharValue(workingMemory, object2);
        }

        public String toString() {
            return "Character <=";
        }
    }

    static class CharacterLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterLessEvaluator();

        private CharacterLessEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getCharValue(workingMemory, object1) < object2.getCharValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.CharVariableContextEntry)context).right < context.declaration.getExtractor().getCharValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getCharValue(workingMemory, right) < ((VariableRestriction.CharVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getCharValue(workingMemory, object1) < extractor2.getCharValue(workingMemory, object2);
        }

        public String toString() {
            return "Character <";
        }
    }

    static class CharacterNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterNotEqualEvaluator();

        private CharacterNotEqualEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getCharValue(workingMemory, object1) != object2.getCharValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return context.declaration.getExtractor().getCharValue(workingMemory, left) != ((VariableRestriction.CharVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return ((VariableRestriction.CharVariableContextEntry)context).left != context.extractor.getCharValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return !extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return true;
            }
            return extractor1.getCharValue(workingMemory, object1) != extractor2.getCharValue(workingMemory, object2);
        }

        public String toString() {
            return "Character !=";
        }
    }

    static class CharacterEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterEqualEvaluator();

        private CharacterEqualEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getCharValue(workingMemory, object1) == object2.getCharValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return context.declaration.getExtractor().getCharValue(workingMemory, left) == ((VariableRestriction.CharVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return ((VariableRestriction.CharVariableContextEntry)context).left == context.extractor.getCharValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return false;
            }
            return extractor1.getCharValue(workingMemory, object1) == extractor2.getCharValue(workingMemory, object2);
        }

        public String toString() {
            return "Character ==";
        }
    }
}

