/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.asm.ClassWriter;
import org.drools.asm.FieldVisitor;
import org.drools.asm.Label;
import org.drools.asm.MethodVisitor;
import org.drools.asm.Type;
import org.drools.base.ShadowProxy;
import org.drools.util.ShadowProxyUtils;

public class ShadowProxyFactory {
    private static final String UPDATE_PROXY = "updateProxy";
    private static final String SET_SHADOWED_OBJECT = "setShadowedObject";
    private static final String GET_SHADOWED_OBJECT = "getShadowedObject";
    private static final String BASE_INTERFACE = Type.getInternalName(ShadowProxy.class);
    public static final String FIELD_SET_FLAG = "IsSet";
    public static final String DELEGATE_FIELD_NAME = "delegate";
    public static final String HASHCACHE_FIELD_NAME = "__hashCache";
    private static final ProtectionDomain PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return (class$org$drools$base$ShadowProxyFactory == null ? (class$org$drools$base$ShadowProxyFactory = ShadowProxyFactory.class$("org.drools.base.ShadowProxyFactory")) : class$org$drools$base$ShadowProxyFactory).getProtectionDomain();
        }
    });
    static /* synthetic */ Class class$org$drools$base$ShadowProxyFactory;

    public static Class getProxy(Class clazz) {
        try {
            if (!ShadowProxyFactory.isPossibleToGenerateTheProxyFor(clazz)) {
                return null;
            }
            String className = ShadowProxyFactory.getInternalProxyClassNameForClass(clazz);
            byte[] bytes = ShadowProxyFactory.dump(clazz, className);
            ByteArrayClassLoader classLoader = new ByteArrayClassLoader(Thread.currentThread().getContextClassLoader());
            Class newClass = classLoader.defineClass(className.replace('/', '.'), bytes, PROTECTION_DOMAIN);
            return newClass;
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public static byte[] getProxyBytes(Class clazz) {
        try {
            if (!ShadowProxyFactory.isPossibleToGenerateTheProxyFor(clazz)) {
                return null;
            }
            String className = ShadowProxyFactory.getInternalProxyClassNameForClass(clazz);
            byte[] bytes = ShadowProxyFactory.dump(clazz, className);
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    protected static boolean isPossibleToGenerateTheProxyFor(Class clazz) throws Exception {
        if ((clazz.getModifiers() & 0x10) != 0) {
            return false;
        }
        try {
            Method equals = clazz.getMethod("equals", Object.class);
            if (Modifier.isFinal(equals.getModifiers())) {
                return false;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            Method hashcode = clazz.getMethod("hashCode", new Class[0]);
            if (Modifier.isFinal(hashcode.getModifiers())) {
                return false;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return true;
    }

    public static String getInternalProxyClassNameForClass(Class clazz) {
        String className = null;
        className = clazz.getPackage() != null && (clazz.getPackage().getName().startsWith("java.") || clazz.getPackage().getName().startsWith("javax.")) ? "org/drools/shadow/" + Type.getInternalName(clazz) + "ShadowProxy" : Type.getInternalName(clazz) + "ShadowProxy";
        return className;
    }

    public static String getProxyClassNameForClass(Class clazz) {
        String className = null;
        Package pkg = clazz.getPackage();
        className = pkg != null && (pkg.getName().startsWith("java.") || pkg.getName().startsWith("javax.")) ? "org.drools.shadow." + clazz.getName() + "ShadowProxy" : clazz.getName() + "ShadowProxy";
        return className;
    }

    protected static byte[] dump(Class clazz, String className) throws Exception {
        ClassWriter cw = new ClassWriter(true);
        ShadowProxyFactory.buildClassHeader(clazz, className, cw);
        ShadowProxyFactory.buildConstructor(clazz, className, cw);
        ShadowProxyFactory.buildField(DELEGATE_FIELD_NAME, Type.getDescriptor(clazz), cw);
        Method getShadowed = ShadowProxy.class.getDeclaredMethod(GET_SHADOWED_OBJECT, new Class[0]);
        Method setShadowed = ShadowProxy.class.getDeclaredMethod(SET_SHADOWED_OBJECT, Object.class);
        ShadowProxyFactory.buildSimpleGetMethod(DELEGATE_FIELD_NAME, clazz, getShadowed, className, clazz, cw);
        ShadowProxyFactory.buildSetShadowedObject(clazz, className, setShadowed, cw);
        if (Collection.class.isAssignableFrom(clazz)) {
            ShadowProxyFactory.buildCollectionClass(clazz, className, cw);
        } else if (Map.class.isAssignableFrom(clazz)) {
            ShadowProxyFactory.buildMapClass(clazz, className, cw);
        } else {
            ShadowProxyFactory.buildRegularClass(clazz, className, cw);
        }
        return cw.toByteArray();
    }

    private static void buildCollectionClass(Class clazz, String className, ClassWriter cw) {
        ShadowProxyFactory.buildCollectionUpdateProxyMethod(clazz, className, cw);
    }

    private static void buildMapClass(Class clazz, String className, ClassWriter cw) {
        ShadowProxyFactory.buildMapUpdateProxyMethod(clazz, className, cw);
    }

    private static void buildRegularClass(Class clazz, String className, ClassWriter cw) {
        HashMap<String, Method> fieldTypes = new HashMap<String, Method>();
        Method[] methods = ShadowProxyFactory.getMethods(clazz);
        for (int i = 0; i < methods.length; ++i) {
            if (Modifier.isFinal(methods[i].getModifiers()) || !Modifier.isPublic(methods[i].getModifiers()) || Modifier.isStatic(methods[i].getModifiers())) continue;
            if (!(methods[i].getReturnType().equals(Void.TYPE) || methods[i].getParameterTypes().length != 0 || methods[i].getName().equals("hashCode") || methods[i].getName().equals("toString"))) {
                String fieldName = methods[i].getName();
                ShadowProxyFactory.buildField(fieldName, Type.getDescriptor(methods[i].getReturnType()), cw);
                fieldTypes.put(fieldName, methods[i]);
                ShadowProxyFactory.buildField(fieldName + FIELD_SET_FLAG, Type.BOOLEAN_TYPE.getDescriptor(), cw);
                ShadowProxyFactory.buildGetMethod(fieldName, methods[i].getReturnType(), fieldName + FIELD_SET_FLAG, methods[i], className, clazz, cw);
                continue;
            }
            if (methods[i].getName().equals("hashCode") || methods[i].getName().equals("equals")) continue;
            ShadowProxyFactory.buildDelegateMethod(methods[i], clazz, className, cw);
        }
        ShadowProxyFactory.buildUpdateProxyMethod(fieldTypes, className, cw);
        ShadowProxyFactory.buildEquals(cw, className, clazz, fieldTypes);
        ShadowProxyFactory.buildField(HASHCACHE_FIELD_NAME, Type.getDescriptor(Integer.TYPE), cw);
        ShadowProxyFactory.buildHashCode(cw, className, clazz, fieldTypes);
    }

    private static Method[] getMethods(Class clazz) {
        HashMap<String, HashMap<ParametersWrapper, Method>> map = new HashMap<String, HashMap<ParametersWrapper, Method>>();
        ArrayList<Method> helperList = new ArrayList<Method>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method previous = null;
            HashMap<ParametersWrapper, Method> signatures = (HashMap<ParametersWrapper, Method>)map.get(methods[i].getName());
            ParametersWrapper key = new ParametersWrapper(methods[i].getParameterTypes());
            if (signatures != null) {
                previous = (Method)signatures.get(key);
            }
            if (previous != null && !previous.getReturnType().isAssignableFrom(methods[i].getReturnType())) continue;
            if (signatures == null) {
                signatures = new HashMap<ParametersWrapper, Method>();
                map.put(methods[i].getName(), signatures);
            }
            if (signatures.put(key, methods[i]) != null) {
                helperList.remove(previous);
            }
            helperList.add(methods[i]);
        }
        return helperList.toArray(new Method[helperList.size()]);
    }

    protected static void buildClassHeader(Class clazz, String className, ClassWriter cw) {
        if (clazz.isInterface()) {
            cw.visit(46, 33, className, null, Type.getInternalName(Object.class), new String[]{BASE_INTERFACE, Type.getInternalName(clazz)});
        } else {
            cw.visit(46, 33, className, null, Type.getInternalName(clazz), new String[]{BASE_INTERFACE});
        }
        cw.visitSource(null, null);
    }

    protected static void buildField(String name, String type, ClassWriter cw) {
        FieldVisitor fv = cw.visitField(2, name, type, null, null);
        fv.visitEnd();
    }

    private static void buildConstructor(Class clazz, String className, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(clazz)}), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(41, l0);
        mv.visitVarInsn(25, 0);
        if (clazz.isInterface()) {
            mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        } else {
            mv.visitMethodInsn(183, Type.getInternalName(clazz), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        }
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(42, l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(43, l2);
        mv.visitInsn(177);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l3, 0);
        mv.visitLocalVariable(DELEGATE_FIELD_NAME, Type.getDescriptor(clazz), null, l0, l3, 1);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected static void buildGetMethod(String fieldName, Class fieldType, String fieldFlag, Method method, String className, Class clazz, ClassWriter cw) {
        Class[] exceptionTypes = method.getExceptionTypes();
        String[] exceptions = ShadowProxyFactory.getExceptionArrayAsString(exceptionTypes);
        MethodVisitor mv = cw.visitMethod(1, method.getName(), Type.getMethodDescriptor(method), null, exceptions);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, fieldFlag, Type.BOOLEAN_TYPE.getDescriptor());
        Label l1 = new Label();
        mv.visitJumpInsn(154, l1);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(4);
        mv.visitFieldInsn(181, className, fieldFlag, Type.BOOLEAN_TYPE.getDescriptor());
        if (Map.class.isAssignableFrom(fieldType) || Collection.class.isAssignableFrom(fieldType) || fieldType.isArray()) {
            Label l01 = new Label();
            mv.visitLabel(l01);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
            if (clazz.isInterface()) {
                mv.visitMethodInsn(185, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
            } else {
                mv.visitMethodInsn(182, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
            }
            mv.visitVarInsn(58, 1);
            Label l11 = new Label();
            mv.visitLabel(l11);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, Type.getInternalName(ShadowProxyUtils.class), "cloneObject", "(Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(192, Type.getInternalName(fieldType));
            mv.visitFieldInsn(181, className, fieldName, Type.getDescriptor(fieldType));
        } else {
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
            if (clazz.isInterface()) {
                mv.visitMethodInsn(185, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
            } else {
                mv.visitMethodInsn(182, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
            }
            mv.visitFieldInsn(181, className, fieldName, Type.getDescriptor(fieldType));
        }
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, fieldName, Type.getDescriptor(fieldType));
        mv.visitInsn(Type.getType(fieldType).getOpcode(172));
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l4, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected static void buildSimpleGetMethod(String fieldName, Class fieldType, Method method, String className, Class clazz, ClassWriter cw) {
        Class[] exceptionTypes = method.getExceptionTypes();
        String[] exceptions = ShadowProxyFactory.getExceptionArrayAsString(exceptionTypes);
        MethodVisitor mv = cw.visitMethod(1, method.getName(), Type.getMethodDescriptor(method), null, exceptions);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, fieldName, Type.getDescriptor(fieldType));
        mv.visitInsn(Type.getType(fieldType).getOpcode(172));
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l4, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected static void buildUpdateProxyMethod(Map fieldTypes, String className, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, UPDATE_PROXY, Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        Iterator it = fieldTypes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String fieldName = (String)entry.getKey();
            String fieldFlag = fieldName + FIELD_SET_FLAG;
            Class<?> fieldType = ((Method)entry.getValue()).getReturnType();
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 0);
            if (fieldType.isPrimitive()) {
                if (fieldType.equals(Long.TYPE)) {
                    mv.visitInsn(9);
                } else if (fieldType.equals(Double.TYPE)) {
                    mv.visitInsn(14);
                } else if (fieldType.equals(Float.TYPE)) {
                    mv.visitInsn(11);
                } else {
                    mv.visitInsn(3);
                }
            } else {
                mv.visitInsn(1);
            }
            mv.visitFieldInsn(181, className, fieldName, Type.getDescriptor(fieldType));
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(3);
            mv.visitFieldInsn(181, className, fieldFlag, Type.BOOLEAN_TYPE.getDescriptor());
        }
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, className, HASHCACHE_FIELD_NAME, Type.getDescriptor(Integer.TYPE));
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitInsn(177);
        Label l5 = new Label();
        mv.visitLabel(l5);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l5, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected static void buildSetShadowedObject(Class clazz, String className, Method setShadowed, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, setShadowed.getName(), Type.getMethodDescriptor(setShadowed), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(clazz));
        mv.visitFieldInsn(181, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
        if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, className, UPDATE_PROXY, Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        }
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitInsn(177);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l3, 0);
        mv.visitLocalVariable("object", Type.getDescriptor(Object.class), null, l0, l3, 1);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected static void buildCollectionUpdateProxyMethod(Class clazz, String className, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, UPDATE_PROXY, Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, className, "clear", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
        mv.visitMethodInsn(182, className, "addAll", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[]{Type.getType(Collection.class)}));
        mv.visitInsn(87);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitInsn(177);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l3, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected static void buildMapUpdateProxyMethod(Class clazz, String className, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, UPDATE_PROXY, Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, className, "clear", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
        mv.visitMethodInsn(182, className, "putAll", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(Map.class)}));
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitInsn(177);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l3, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected static void buildDelegateMethod(Method method, Class clazz, String className, ClassWriter cw) {
        String[] exceptions = ShadowProxyFactory.getExceptionArrayAsString(method.getExceptionTypes());
        MethodVisitor mv = cw.visitMethod(1, method.getName(), Type.getMethodDescriptor(method), null, exceptions);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
        Class<?>[] parameters = method.getParameterTypes();
        int offset = 1;
        for (int i = 0; i < parameters.length; ++i) {
            Type type = Type.getType(parameters[i]);
            mv.visitVarInsn(type.getOpcode(21), offset);
            offset += type.getSize();
        }
        if (clazz.isInterface()) {
            mv.visitMethodInsn(185, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
        } else {
            mv.visitMethodInsn(182, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
        }
        mv.visitInsn(Type.getType(method.getReturnType()).getOpcode(172));
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l1, 0);
        int offset2 = 0;
        for (int i = 0; i < parameters.length; ++i) {
            mv.visitLocalVariable("arg" + i, Type.getDescriptor(parameters[i]), null, l0, l1, offset2);
            offset2 += Type.getType(parameters[i]).getSize();
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected static void buildEquals(ClassWriter cw, String className, Class clazz, Map fieldTypes) {
        MethodVisitor mv = cw.visitMethod(1, "equals", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[]{Type.getType(Object.class)}), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(165, l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
        mv.visitVarInsn(25, 1);
        mv.visitJumpInsn(165, l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
        mv.visitVarInsn(25, 1);
        if (clazz.isInterface()) {
            mv.visitMethodInsn(185, Type.getInternalName(clazz), "equals", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[]{Type.getType(Object.class)}));
        } else {
            mv.visitMethodInsn(182, Type.getInternalName(clazz), "equals", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[]{Type.getType(Object.class)}));
        }
        Label l2 = new Label();
        mv.visitJumpInsn(153, l2);
        mv.visitLabel(l1);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 1);
        Label l3 = new Label();
        mv.visitJumpInsn(198, l3);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(193, Type.getInternalName(clazz));
        Label l4 = new Label();
        mv.visitJumpInsn(154, l4);
        mv.visitLabel(l3);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l4);
        Label c0 = new Label();
        mv.visitLabel(c0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(193, className);
        Label c1 = new Label();
        mv.visitJumpInsn(153, c1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, className);
        mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
        Label c2 = new Label();
        mv.visitJumpInsn(165, c2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, className);
        mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
        if (clazz.isInterface()) {
            mv.visitMethodInsn(185, Type.getInternalName(clazz), "equals", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[]{Type.getType(Object.class)}));
        } else {
            mv.visitMethodInsn(182, Type.getInternalName(clazz), "equals", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[]{Type.getType(Object.class)}));
        }
        mv.visitJumpInsn(153, c1);
        mv.visitLabel(c2);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(c1);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(clazz));
        mv.visitVarInsn(58, 2);
        int count = 0;
        Iterator it = fieldTypes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String fieldName = (String)entry.getKey();
            Method method = (Method)entry.getValue();
            Class<?> fieldType = method.getReturnType();
            String fieldFlag = fieldName + FIELD_SET_FLAG;
            ++count;
            Label goNext = new Label();
            Label l5 = new Label();
            mv.visitLabel(l5);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, fieldFlag, Type.BOOLEAN_TYPE.getDescriptor());
            Label l6 = new Label();
            mv.visitJumpInsn(154, l6);
            Label l7 = new Label();
            mv.visitLabel(l7);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
            if (clazz.isInterface()) {
                mv.visitMethodInsn(185, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
            } else {
                mv.visitMethodInsn(182, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
            }
            mv.visitFieldInsn(181, className, fieldName, Type.getDescriptor(fieldType));
            Label l8 = new Label();
            mv.visitLabel(l8);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(4);
            mv.visitFieldInsn(181, className, fieldFlag, Type.BOOLEAN_TYPE.getDescriptor());
            mv.visitLabel(l6);
            if (fieldType.isPrimitive()) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, fieldName, Type.getDescriptor(fieldType));
                mv.visitVarInsn(25, 2);
                if (clazz.isInterface()) {
                    mv.visitMethodInsn(185, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
                } else {
                    mv.visitMethodInsn(182, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
                }
                if (fieldType.equals(Long.TYPE)) {
                    mv.visitInsn(148);
                    mv.visitJumpInsn(153, goNext);
                } else if (fieldType.equals(Double.TYPE)) {
                    mv.visitInsn(151);
                    mv.visitJumpInsn(153, goNext);
                } else if (fieldType.equals(Float.TYPE)) {
                    mv.visitInsn(149);
                    mv.visitJumpInsn(153, goNext);
                } else {
                    mv.visitJumpInsn(159, goNext);
                }
                mv.visitInsn(3);
                mv.visitInsn(172);
            } else {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, fieldName, Type.getDescriptor(fieldType));
                Label secondIfPart = new Label();
                mv.visitJumpInsn(199, secondIfPart);
                mv.visitVarInsn(25, 2);
                if (clazz.isInterface()) {
                    mv.visitMethodInsn(185, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
                } else {
                    mv.visitMethodInsn(182, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
                }
                Label returnFalse = new Label();
                mv.visitJumpInsn(199, returnFalse);
                mv.visitLabel(secondIfPart);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, fieldName, Type.getDescriptor(fieldType));
                mv.visitJumpInsn(198, goNext);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, fieldName, Type.getDescriptor(fieldType));
                mv.visitVarInsn(25, 2);
                if (clazz.isInterface()) {
                    mv.visitMethodInsn(185, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
                } else {
                    mv.visitMethodInsn(182, Type.getInternalName(clazz), method.getName(), Type.getMethodDescriptor(method));
                }
                if (fieldType.isInterface()) {
                    mv.visitMethodInsn(185, Type.getInternalName(fieldType), "equals", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[]{Type.getType(class$java$lang$Object == null ? ShadowProxyFactory.class$("java.lang.Object") : class$java$lang$Object)}));
                } else {
                    mv.visitMethodInsn(182, Type.getInternalName(fieldType), "equals", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[]{Type.getType(class$java$lang$Object == null ? ShadowProxyFactory.class$("java.lang.Object") : class$java$lang$Object)}));
                }
                mv.visitJumpInsn(154, goNext);
                mv.visitLabel(returnFalse);
                mv.visitInsn(3);
                mv.visitInsn(172);
            }
            mv.visitLabel(goNext);
        }
        if (count > 0) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitInsn(172);
        Label lastLabel = new Label();
        mv.visitLabel(lastLabel);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, lastLabel, 0);
        mv.visitLocalVariable("object", Type.getDescriptor(Object.class), null, l0, lastLabel, 1);
        mv.visitLocalVariable("other", Type.getDescriptor(clazz), null, l0, lastLabel, 2);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected static void buildCollectionEquals(ClassWriter cw, String className, Class clazz) {
        MethodVisitor mv = cw.visitMethod(1, "equals", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[]{Type.getType(Object.class)}), null, null);
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(166, l1);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
        mv.visitVarInsn(25, 1);
        if (clazz.isInterface()) {
            mv.visitMethodInsn(185, Type.getInternalName(clazz), "equals", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[]{Type.getType(Object.class)}));
        } else {
            mv.visitMethodInsn(182, Type.getInternalName(clazz), "equals", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[]{Type.getType(Object.class)}));
        }
        mv.visitInsn(172);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l3, 0);
        mv.visitLocalVariable("object", Type.getDescriptor(Object.class), null, l0, l3, 1);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected static void buildHashCode(ClassWriter cw, String className, Class clazz, Map fieldTypes) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, HASHCACHE_FIELD_NAME, Type.INT_TYPE.getDescriptor());
        Label l1 = new Label();
        mv.visitJumpInsn(154, l1);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, DELEGATE_FIELD_NAME, Type.getDescriptor(clazz));
        if (clazz.isInterface()) {
            mv.visitMethodInsn(185, Type.getInternalName(clazz), "hashCode", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]));
        } else {
            mv.visitMethodInsn(182, Type.getInternalName(clazz), "hashCode", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]));
        }
        mv.visitFieldInsn(181, className, HASHCACHE_FIELD_NAME, Type.INT_TYPE.getDescriptor());
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, HASHCACHE_FIELD_NAME, Type.INT_TYPE.getDescriptor());
        mv.visitInsn(172);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l3, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static String[] getExceptionArrayAsString(Class[] exceptionTypes) {
        String[] exceptions = new String[exceptionTypes.length];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptions[i] = Type.getInternalName(exceptionTypes[i]);
        }
        return exceptions;
    }

    static class ByteArrayClassLoader
    extends ClassLoader {
        public ByteArrayClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class defineClass(String name, byte[] bytes, ProtectionDomain PROTECTION_DOMAIN) {
            return this.defineClass(name, bytes, 0, bytes.length, PROTECTION_DOMAIN);
        }
    }

    private static class ParametersWrapper {
        private Class[] parameters;

        public ParametersWrapper(Class[] parameters) {
            this.parameters = parameters;
        }

        public int hashCode() {
            return this.parameters.length;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ParametersWrapper)) {
                return false;
            }
            ParametersWrapper other = (ParametersWrapper)o;
            if (this.parameters.length != other.parameters.length) {
                return false;
            }
            for (int i = 0; i < this.parameters.length; ++i) {
                if (this.parameters[i].equals(other.parameters[i])) continue;
                return false;
            }
            return true;
        }
    }
}

