/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.asm.ClassWriter;
import org.drools.asm.Label;
import org.drools.asm.MethodVisitor;
import org.drools.asm.Type;
import org.drools.base.BaseClassFieldExtractor;
import org.drools.base.ValueType;
import org.drools.base.extractors.BaseBooleanClassFieldExtractor;
import org.drools.base.extractors.BaseByteClassFieldExtractor;
import org.drools.base.extractors.BaseCharClassFieldExtractor;
import org.drools.base.extractors.BaseDoubleClassFieldExtractor;
import org.drools.base.extractors.BaseFloatClassFieldExtractor;
import org.drools.base.extractors.BaseIntClassFieldExtractor;
import org.drools.base.extractors.BaseLongClassFieldExtractors;
import org.drools.base.extractors.BaseObjectClassFieldExtractor;
import org.drools.base.extractors.BaseShortClassFieldExtractor;
import org.drools.base.extractors.MVELClassFieldExtractor;
import org.drools.base.extractors.SelfReferenceClassFieldExtractor;
import org.drools.common.InternalWorkingMemory;
import org.drools.util.asm.ClassFieldInspector;

public class ClassFieldExtractorFactory {
    private static final String BASE_PACKAGE = "org/drools/base";
    private static final String SELF_REFERENCE_FIELD = "this";
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private static final Map inspectors;
    private static ByteArrayClassLoader byteArrayClassLoader;
    static /* synthetic */ Class class$org$drools$base$ClassFieldExtractorFactory;

    public static BaseClassFieldExtractor getClassFieldExtractor(Class clazz, String fieldName, ClassLoader classLoader) {
        if (byteArrayClassLoader == null) {
            if (classLoader == null) {
                throw new RuntimeDroolsException("ClassFieldExtractorFactory cannot have a null parent ClassLoader");
            }
            byteArrayClassLoader = new ByteArrayClassLoader(classLoader);
        }
        try {
            if (SELF_REFERENCE_FIELD.equals(fieldName)) {
                return new SelfReferenceClassFieldExtractor(clazz, fieldName);
            }
            if (fieldName.indexOf(46) > -1 || fieldName.indexOf(91) > -1) {
                return new MVELClassFieldExtractor(clazz, fieldName, classLoader);
            }
            ClassFieldInspector inspector = (ClassFieldInspector)inspectors.get(clazz);
            if (inspector == null) {
                inspector = new ClassFieldInspector(clazz);
                inspectors.put(clazz, inspector);
            }
            Class fieldType = (Class)inspector.getFieldTypes().get(fieldName);
            Method getterMethod = (Method)inspector.getGetterMethods().get(fieldName);
            String className = "org/drools/base/" + Type.getInternalName(clazz) + "$" + getterMethod.getName();
            byte[] bytes = ClassFieldExtractorFactory.dump(clazz, className, getterMethod, fieldType, clazz.isInterface());
            Class newClass = byteArrayClassLoader.defineClass(className.replace('/', '.'), bytes, PROTECTION_DOMAIN);
            Integer index = (Integer)inspector.getFieldNames().get(fieldName);
            ValueType valueType = ValueType.determineValueType(fieldType);
            Object[] params = new Object[]{index, fieldType, valueType};
            return (BaseClassFieldExtractor)newClass.getConstructors()[0].newInstance(params);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    private static byte[] dump(Class originalClass, String className, Method getterMethod, Class fieldType, boolean isInterface) throws Exception {
        ClassWriter cw = new ClassWriter(true);
        Class superClass = ClassFieldExtractorFactory.getSuperClassFor(fieldType);
        ClassFieldExtractorFactory.buildClassHeader(superClass, className, cw);
        ClassFieldExtractorFactory.build3ArgConstructor(superClass, className, cw);
        ClassFieldExtractorFactory.buildGetMethod(originalClass, className, superClass, getterMethod, cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected static void buildClassHeader(Class superClass, String className, ClassWriter cw) {
        cw.visit(46, 33, className, null, Type.getInternalName(superClass), null);
        cw.visitSource(null, null);
    }

    private static void build3ArgConstructor(Class superClazz, String className, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(Integer.TYPE), Type.getType(Class.class), Type.getType(ValueType.class)}), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, Type.getInternalName(superClazz), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(Integer.TYPE), Type.getType(Class.class), Type.getType(ValueType.class)}));
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitInsn(177);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable(SELF_REFERENCE_FIELD, "L" + className + ";", null, l0, l2, 0);
        mv.visitLocalVariable("index", Type.getDescriptor(Integer.TYPE), null, l0, l2, 1);
        mv.visitLocalVariable("fieldType", Type.getDescriptor(Class.class), null, l0, l2, 2);
        mv.visitLocalVariable("valueType", Type.getDescriptor(ValueType.class), null, l0, l2, 3);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected static void buildGetMethod(Class originalClass, String className, Class superClass, Method getterMethod, ClassWriter cw) {
        Method overridingMethod;
        Class<?> fieldType = getterMethod.getReturnType();
        try {
            overridingMethod = superClass.getMethod(ClassFieldExtractorFactory.getOverridingMethodName(fieldType), InternalWorkingMemory.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report back to JBoss Rules team.", e);
        }
        MethodVisitor mv = cw.visitMethod(1, overridingMethod.getName(), Type.getMethodDescriptor(overridingMethod), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, Type.getInternalName(originalClass));
        if (originalClass.isInterface()) {
            mv.visitMethodInsn(185, Type.getInternalName(originalClass), getterMethod.getName(), Type.getMethodDescriptor(getterMethod));
        } else {
            mv.visitMethodInsn(182, Type.getInternalName(originalClass), getterMethod.getName(), Type.getMethodDescriptor(getterMethod));
        }
        mv.visitInsn(Type.getType(fieldType).getOpcode(172));
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable(SELF_REFERENCE_FIELD, "L" + className + ";", null, l0, l1, 0);
        mv.visitLocalVariable("workingMemory", Type.getDescriptor(InternalWorkingMemory.class), null, l0, l1, 1);
        mv.visitLocalVariable("object", Type.getDescriptor(Object.class), null, l0, l1, 2);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static String getOverridingMethodName(Class fieldType) {
        String ret = null;
        if (fieldType.isPrimitive()) {
            if (fieldType == Character.TYPE) {
                ret = "getCharValue";
            } else if (fieldType == Byte.TYPE) {
                ret = "getByteValue";
            } else if (fieldType == Short.TYPE) {
                ret = "getShortValue";
            } else if (fieldType == Integer.TYPE) {
                ret = "getIntValue";
            } else if (fieldType == Long.TYPE) {
                ret = "getLongValue";
            } else if (fieldType == Float.TYPE) {
                ret = "getFloatValue";
            } else if (fieldType == Double.TYPE) {
                ret = "getDoubleValue";
            } else if (fieldType == Boolean.TYPE) {
                ret = "getBooleanValue";
            }
        } else {
            ret = "getValue";
        }
        return ret;
    }

    private static Class getSuperClassFor(Class fieldType) {
        Class ret = null;
        if (fieldType.isPrimitive()) {
            if (fieldType == Character.TYPE) {
                ret = BaseCharClassFieldExtractor.class;
            } else if (fieldType == Byte.TYPE) {
                ret = BaseByteClassFieldExtractor.class;
            } else if (fieldType == Short.TYPE) {
                ret = BaseShortClassFieldExtractor.class;
            } else if (fieldType == Integer.TYPE) {
                ret = BaseIntClassFieldExtractor.class;
            } else if (fieldType == Long.TYPE) {
                ret = BaseLongClassFieldExtractors.class;
            } else if (fieldType == Float.TYPE) {
                ret = BaseFloatClassFieldExtractor.class;
            } else if (fieldType == Double.TYPE) {
                ret = BaseDoubleClassFieldExtractor.class;
            } else if (fieldType == Boolean.TYPE) {
                ret = BaseBooleanClassFieldExtractor.class;
            }
        } else {
            ret = BaseObjectClassFieldExtractor.class;
        }
        return ret;
    }

    static {
        inspectors = new HashMap();
        PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return (class$org$drools$base$ClassFieldExtractorFactory == null ? (class$org$drools$base$ClassFieldExtractorFactory = ClassFieldExtractorFactory.class$("org.drools.base.ClassFieldExtractorFactory")) : class$org$drools$base$ClassFieldExtractorFactory).getProtectionDomain();
            }
        });
    }

    static class ByteArrayClassLoader
    extends ClassLoader {
        public ByteArrayClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class defineClass(String name, byte[] bytes, ProtectionDomain domain) {
            return this.defineClass(name, bytes, 0, bytes.length, domain);
        }
    }
}

