/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.base.ClassFieldExtractorFactory;
import org.drools.base.ValueType;
import org.drools.common.InternalWorkingMemory;
import org.drools.spi.FieldExtractor;

public class ClassFieldExtractor
implements FieldExtractor {
    private static final long serialVersionUID = 400L;
    private String fieldName;
    private Class clazz;
    private transient FieldExtractor extractor;

    public ClassFieldExtractor(Class clazz, String fieldName) {
        this(clazz, fieldName, null);
    }

    public ClassFieldExtractor(Class clazz, String fieldName, ClassLoader classLoader) {
        this.clazz = clazz;
        this.fieldName = fieldName;
        this.init(classLoader);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException, Exception {
        is.defaultReadObject();
    }

    private Object readResolve() {
        return ClassFieldExtractorCache.getExtractor(this.clazz, this.fieldName, this.clazz.getClassLoader());
    }

    public void init(ClassLoader classLoader) {
        try {
            this.extractor = ClassFieldExtractorFactory.getClassFieldExtractor(this.clazz, this.fieldName, classLoader);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public int getIndex() {
        return this.extractor.getIndex();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getValue(workingMemory, object);
    }

    public ValueType getValueType() {
        return this.extractor.getValueType();
    }

    public Class getExtractToClass() {
        return this.extractor.getExtractToClass();
    }

    public String toString() {
        return "[ClassFieldExtractor class=" + this.clazz + " field=" + this.fieldName + "]";
    }

    public int hashCode() {
        return this.getValueType().hashCode() * 17 + this.getIndex();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ClassFieldExtractor)) {
            return false;
        }
        ClassFieldExtractor other = (ClassFieldExtractor)object;
        return this.extractor.getValueType() == other.getValueType() && this.extractor.getIndex() == other.getIndex();
    }

    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getBooleanValue(workingMemory, object);
    }

    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getByteValue(workingMemory, object);
    }

    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getCharValue(workingMemory, object);
    }

    public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getDoubleValue(workingMemory, object);
    }

    public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getFloatValue(workingMemory, object);
    }

    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getIntValue(workingMemory, object);
    }

    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getLongValue(workingMemory, object);
    }

    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getShortValue(workingMemory, object);
    }

    public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.isNullValue(workingMemory, object);
    }

    public Method getNativeReadMethod() {
        return this.extractor.getNativeReadMethod();
    }

    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        return this.extractor.getHashCode(workingMemory, object);
    }

    public boolean isGlobal() {
        return false;
    }
}

