/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.RuntimeDroolsException;
import org.drools.agent.AgentEventListener;
import org.drools.agent.PackageProvider;
import org.drools.rule.Package;

public class RuleAgent {
    public static final String NEW_INSTANCE = "newInstance";
    public static final String FILES = "file";
    public static final String DIRECTORY = "dir";
    public static final String URLS = "url";
    public static final String POLL_INTERVAL = "poll";
    public static final String CONFIG_NAME = "name";
    public static final String LOCAL_URL_CACHE = "localCacheDir";
    public static Map PACKAGE_PROVIDERS = new HashMap(){
        {
            this.put(RuleAgent.FILES, class$org$drools$agent$FileScanner == null ? (class$org$drools$agent$FileScanner = RuleAgent.class$("org.drools.agent.FileScanner")) : class$org$drools$agent$FileScanner);
            this.put(RuleAgent.DIRECTORY, class$org$drools$agent$DirectoryScanner == null ? (class$org$drools$agent$DirectoryScanner = RuleAgent.class$("org.drools.agent.DirectoryScanner")) : class$org$drools$agent$DirectoryScanner);
            this.put(RuleAgent.URLS, class$org$drools$agent$URLScanner == null ? (class$org$drools$agent$URLScanner = RuleAgent.class$("org.drools.agent.URLScanner")) : class$org$drools$agent$URLScanner);
        }
    };
    private boolean newInstance;
    private RuleBase ruleBase;
    private Timer timer;
    List providers;
    Map packages = new HashMap();
    AgentEventListener listener = this.getDefaultListener();
    private int secondsToRefresh;
    static /* synthetic */ Class class$org$drools$agent$FileScanner;
    static /* synthetic */ Class class$org$drools$agent$DirectoryScanner;
    static /* synthetic */ Class class$org$drools$agent$URLScanner;

    public static RuleAgent newRuleAgent(Properties config) {
        RuleAgent agent = new RuleAgent();
        agent.init(config);
        return agent;
    }

    public static RuleAgent newRuleAgent(Properties config, AgentEventListener listener) {
        RuleAgent agent = new RuleAgent();
        agent.listener = listener;
        agent.init(config);
        return agent;
    }

    void init(Properties config) {
        boolean newInstance = Boolean.valueOf(config.getProperty(NEW_INSTANCE, "false"));
        int secondsToRefresh = Integer.parseInt(config.getProperty(POLL_INTERVAL, "-1"));
        String name = config.getProperty(CONFIG_NAME, "default");
        this.listener.setAgentName(name);
        this.listener.info("Configuring with newInstance=" + newInstance + ", secondsToRefresh=" + secondsToRefresh);
        ArrayList<PackageProvider> provs = new ArrayList<PackageProvider>();
        Iterator<Object> iter = config.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            PackageProvider prov = this.getProvider(key, config);
            if (prov == null) continue;
            this.listener.info("Configuring package provider : " + prov.toString());
            provs.add(prov);
        }
        this.configure(newInstance, provs, secondsToRefresh);
    }

    public static RuleAgent newRuleAgent(String propsFileName) {
        RuleAgent agent = new RuleAgent();
        agent.init(agent.loadFromProperties(propsFileName));
        return agent;
    }

    public static RuleAgent newRuleAgent(String propsFileName, AgentEventListener listener) {
        RuleAgent ag = new RuleAgent();
        ag.listener = listener;
        ag.init(ag.loadFromProperties(propsFileName));
        return ag;
    }

    Properties loadFromProperties(String propsFileName) {
        InputStream in = this.getClass().getResourceAsStream(propsFileName);
        Properties props = new Properties();
        try {
            props.load(in);
            return props;
        }
        catch (IOException e) {
            throw new RuntimeDroolsException("Unable to load properties. Needs to be the path and name of a config file on your classpath.", e);
        }
    }

    private PackageProvider getProvider(String key, Properties config) {
        if (!PACKAGE_PROVIDERS.containsKey(key)) {
            return null;
        }
        Class clz = (Class)PACKAGE_PROVIDERS.get(key);
        try {
            PackageProvider prov = (PackageProvider)clz.newInstance();
            prov.setAgentListener(this.listener);
            prov.configure(config);
            return prov;
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException("Unable to load up a package provider for " + key, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Unable to load up a package provider for " + key, e);
        }
    }

    synchronized void configure(boolean newInstance, List provs, int secondsToRefresh) {
        this.newInstance = newInstance;
        this.providers = provs;
        this.refreshRuleBase();
        if (secondsToRefresh != -1) {
            this.startPolling(secondsToRefresh);
        }
    }

    public void refreshRuleBase() {
        ArrayList<Package> changedPackages = new ArrayList<Package>();
        Iterator iter = this.providers.iterator();
        while (iter.hasNext()) {
            PackageProvider prov = (PackageProvider)iter.next();
            Package[] changes = this.checkForChanges(prov);
            if (changes == null || changes.length <= 0) continue;
            changedPackages.addAll(Arrays.asList(changes));
        }
        if (changedPackages.size() > 0) {
            this.listener.info("Applying changes to the rulebase.");
            if (this.newInstance) {
                this.listener.info("Creating a new rulebase as per settings.");
                this.ruleBase = RuleBaseFactory.newRuleBase();
                iter = changedPackages.iterator();
                while (iter.hasNext()) {
                    Package element = (Package)iter.next();
                    this.packages.put(element.getName(), element);
                }
                PackageProvider.applyChanges(this.ruleBase, false, this.packages.values(), this.listener);
            } else {
                PackageProvider.applyChanges(this.ruleBase, true, changedPackages, this.listener);
            }
        }
    }

    private synchronized Package[] checkForChanges(PackageProvider prov) {
        this.listener.debug("SCANNING FOR CHANGE " + prov.toString());
        if (this.ruleBase == null) {
            this.ruleBase = RuleBaseFactory.newRuleBase();
        }
        Package[] changes = prov.loadPackageChanges();
        return changes;
    }

    static List list(String property) {
        if (property == null) {
            return Collections.EMPTY_LIST;
        }
        StringTokenizer st = new StringTokenizer(property, "\n\r\t ");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public synchronized RuleBase getRuleBase() {
        return this.ruleBase;
    }

    RuleAgent() {
    }

    public synchronized void stopPolling() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    public synchronized void startPolling() {
        if (this.timer == null) {
            this.startPolling(this.secondsToRefresh);
        }
    }

    public synchronized void startPolling(int secondsToRefresh) {
        if (this.timer != null) {
            if (this.secondsToRefresh != secondsToRefresh) {
                this.stopPolling();
            } else {
                return;
            }
        }
        this.secondsToRefresh = secondsToRefresh;
        int interval = this.secondsToRefresh * 1000;
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            public void run() {
                try {
                    RuleAgent.this.listener.debug("Checking for updates.");
                    RuleAgent.this.refreshRuleBase();
                }
                catch (Exception e) {
                    RuleAgent.this.listener.exception(e);
                }
            }
        }, interval, (long)interval);
    }

    boolean isNewInstance() {
        return this.newInstance;
    }

    public synchronized boolean isPolling() {
        return this.timer != null;
    }

    private AgentEventListener getDefaultListener() {
        return new AgentEventListener(){
            private String name;

            public String time() {
                Date d = new Date();
                return d.toString();
            }

            public void exception(Exception e) {
                System.err.println("RuleAgent(" + this.name + ") EXCEPTION (" + this.time() + "): " + e.getMessage() + ". Stack trace should follow.");
                e.printStackTrace(System.err);
            }

            public void info(String message) {
                System.err.println("RuleAgent(" + this.name + ") INFO (" + this.time() + "): " + message);
            }

            public void warning(String message) {
                System.err.println("RuleAgent(" + this.name + ") WARNING (" + this.time() + "): " + message);
            }

            public void debug(String message) {
            }

            public void setAgentName(String name) {
                this.name = name;
            }
        };
    }
}

