/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class CollectionUtils {
    public static CollectionFactory createFactory() {
        return new CollectionFactory();
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !CollectionUtils.isEmpty(coll);
    }

    public static class CollectionFactory {
        public <E> Collection<E> create(Class<?> collectionType, int capacity) {
            return this.create(collectionType, null, capacity);
        }

        public <E> Collection<E> create(Class<?> collectionType, Class<?> elementType, int capacity) {
            if (collectionType.isInterface()) {
                if (Set.class == collectionType || Collection.class == collectionType) {
                    return new LinkedHashSet(capacity);
                }
                if (List.class == collectionType) {
                    return new ArrayList(capacity);
                }
                if (SortedSet.class == collectionType || NavigableSet.class == collectionType) {
                    return new TreeSet();
                }
                throw new IllegalArgumentException("Unsupported Collection interface: " + collectionType.getName());
            }
            if (EnumSet.class == collectionType) {
                return EnumSet.noneOf(this.asEnumType(elementType));
            }
            if (!Collection.class.isAssignableFrom(collectionType)) {
                throw new IllegalArgumentException("Unsupported Collection type: " + collectionType.getName());
            }
            try {
                return (Collection)collectionType.newInstance();
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Could not instantiate Collection type: " + collectionType.getName(), ex);
            }
        }

        public <K, V> Map<K, V> createMap(Class<?> mapType, int capacity) {
            return this.createMap(mapType, null, capacity);
        }

        <K, V> Map<K, V> createMap(Class<?> mapType, Class<?> keyType, int size) {
            if (mapType.isInterface()) {
                if (Map.class == mapType) {
                    return new LinkedHashMap(size);
                }
                if (SortedMap.class == mapType || NavigableMap.class == mapType) {
                    return new TreeMap();
                }
                throw new IllegalArgumentException("Unsupported Map interface: " + mapType.getName());
            }
            if (EnumMap.class == mapType) {
                return new EnumMap(this.asEnumType(keyType));
            }
            if (!Map.class.isAssignableFrom(mapType)) {
                throw new IllegalArgumentException("Unsupported Map type: " + mapType.getName());
            }
            try {
                return (Map)mapType.newInstance();
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Could not instantiate Map type: " + mapType.getName(), ex);
            }
        }

        private Class<? extends Enum> asEnumType(Class<?> enumType) {
            if (!Enum.class.isAssignableFrom(enumType)) {
                throw new IllegalArgumentException("Supplied type is not an enum: " + enumType.getName());
            }
            return enumType.asSubclass(Enum.class);
        }
    }
}

