/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.io.File;
import java.util.List;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImageResizeTest {
    private final String GIF_IMAGE_DATA = "data:image/gif;base64,R0lGODdhAgACAKEEAAMA//8AAAD/Bv/8ACwAAAAAAgACAAACAww0BQA7";
    private final String PNG_IMAGE_DATA = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC";
    private WordprocessingMLPackage wordMLPackage;

    @Before
    public void setup() throws Exception {
        this.wordMLPackage = WordprocessingMLPackage.createPackage();
    }

    @Test
    public void testFixedSizeImage() throws Exception {
        Inline inline1 = this.getInline("<div><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC'/></div>");
        Inline inline2 = this.getInline("<div><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' width='40px' height='20px' /></div>");
        Assert.assertTrue((inline2.getExtent().getCx() / inline1.getExtent().getCx() == 20L ? 1 : 0) != 0);
        Assert.assertTrue((inline2.getExtent().getCy() / inline1.getExtent().getCy() == 10L ? 1 : 0) != 0);
    }

    @Test
    public void testCmAgainstPx() throws Exception {
        Inline inline1 = this.getInline("<div><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='20px' width='40px'/></div>");
        Inline inline2 = this.getInline("<div><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='20cm' width='40cm'/></div>");
        Assert.assertTrue((inline2.getExtent().getCx() / inline1.getExtent().getCx() > 10L ? 1 : 0) != 0);
        Assert.assertTrue((inline2.getExtent().getCx() / inline1.getExtent().getCy() > 10L ? 1 : 0) != 0);
    }

    @Test
    public void testScaling() throws Exception {
        Inline inline = this.getInline("<div><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' style='width: 50px'/></div>");
        Assert.assertTrue((inline.getExtent().getCx() == inline.getExtent().getCy() ? 1 : 0) != 0);
    }

    @Test
    public void testHeightWidthInPx() throws Exception {
        String PNG_IMAGE_DATA = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC";
        String html = "<div><p><img src='" + PNG_IMAGE_DATA + "' width='40px' height='20px' /></p>" + "<p><img src='" + PNG_IMAGE_DATA + "' style='width:40px; height:20px' /></p>" + "</div>";
        XHTMLImporterImpl XHTMLImporter2 = new XHTMLImporterImpl(this.wordMLPackage);
        List<Object> convert = XHTMLImporter2.convert(html, null);
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(convert);
        this.wordMLPackage.save(new File(System.getProperty("user.dir") + "/px.docx"));
    }

    private Inline getInline(String html) throws Exception {
        XHTMLImporterImpl XHTMLImporter2 = new XHTMLImporterImpl(this.wordMLPackage);
        List<Object> convert = XHTMLImporter2.convert(html, null);
        return (Inline)((Drawing)((R)((P)convert.get(0)).getContent().get(0)).getContent().get(0)).getAnchorOrInline().get(0);
    }
}

