/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import org.directwebremoting.extend.WaitController;
import org.directwebremoting.impl.AbstractServerLoadMonitor;
import org.directwebremoting.util.HitMonitor;

public class ThreadDroppingServerLoadMonitor
extends AbstractServerLoadMonitor {
    protected int maxHitsPerSecond = 100;
    protected int connectedTime = 60000;
    protected int disconnectedTime = 1;
    protected static final int SECONDS_MONITORED = 10;
    protected HitMonitor hitMonitor = new HitMonitor(10);

    @Override
    public boolean supportsStreaming() {
        return true;
    }

    @Override
    public long getConnectedTime() {
        return this.connectedTime;
    }

    @Override
    public int getDisconnectedTime() {
        return this.disconnectedTime;
    }

    @Override
    public void threadWaitStarting(WaitController controller) {
        this.hitMonitor.recordHit();
        super.threadWaitStarting(controller);
        this.checkLoading();
    }

    @Override
    public void threadWaitEnding(WaitController controller) {
        super.threadWaitEnding(controller);
    }

    private void checkLoading() {
        float hitsPerSecond = (float)this.hitMonitor.getHitsInLastPeriod() / 10.0f;
        float load = hitsPerSecond / (float)this.maxHitsPerSecond;
        this.disconnectedTime = (int)((float)this.disconnectedTime * load);
        if (this.disconnectedTime == 0) {
            this.disconnectedTime = 1;
        }
    }

    public void setMaxHitsPerSecond(int maxHitsPerSecond) {
        this.maxHitsPerSecond = maxHitsPerSecond;
    }
}

