/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import org.dhatim.fastexcel.DataValidation;
import org.dhatim.fastexcel.DataValidationErrorStyle;
import org.dhatim.fastexcel.Formula;
import org.dhatim.fastexcel.Range;
import org.dhatim.fastexcel.Writer;

public class CustomDataValidation
implements DataValidation {
    private static final String TYPE = "custom";
    private final Range range;
    private final Formula formula;
    private boolean allowBlank = true;
    private boolean showDropdown = true;
    private DataValidationErrorStyle errorStyle = DataValidationErrorStyle.INFORMATION;
    private boolean showErrorMessage = false;
    private String errorTitle;
    private String error;

    CustomDataValidation(Range range, Formula formula) {
        this.range = range;
        this.formula = formula;
    }

    public CustomDataValidation allowBlank(boolean allowBlank) {
        this.allowBlank = allowBlank;
        return this;
    }

    public CustomDataValidation showDropdown(boolean showDropdown) {
        this.showDropdown = showDropdown;
        return this;
    }

    public CustomDataValidation errorStyle(DataValidationErrorStyle errorStyle) {
        this.errorStyle = errorStyle;
        return this;
    }

    public CustomDataValidation showErrorMessage(boolean showErrorMessage) {
        this.showErrorMessage = showErrorMessage;
        return this;
    }

    public CustomDataValidation errorTitle(String errorTitle) {
        this.errorTitle = errorTitle;
        return this;
    }

    public CustomDataValidation error(String error) {
        this.error = error;
        return this;
    }

    @Override
    public void write(Writer w) throws IOException {
        w.append("<dataValidation sqref=\"").append(this.range.toString()).append("\" type=\"").append(TYPE).append("\" allowBlank=\"").append(String.valueOf(this.allowBlank)).append("\" showDropDown=\"").append(String.valueOf(!this.showDropdown)).append("\" errorStyle=\"").append(this.errorStyle.toString()).append("\" showErrorMessage=\"").append(String.valueOf(this.showErrorMessage)).append("\" errorTitle=\"").append(this.errorTitle).append("\" error=\"").append(this.error).append("\"><formula1>").append(this.formula.getExpression()).append("</formula1></dataValidation>");
    }
}

