/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.providers.impl;

import com.tridion.broker.StorageException;
import com.tridion.storage.RelatedKeyword;
import com.tridion.storage.StorageManagerFactory;
import com.tridion.storage.StorageTypeMapping;
import com.tridion.storage.dao.BaseDAO;
import com.tridion.storage.dao.WrappableDAO;
import com.tridion.storage.persistence.JPABaseDAO;
import com.tridion.taxonomies.Keyword;
import com.tridion.taxonomies.TaxonomyFactory;
import com.tridion.util.TCMURI;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.NotImplementedException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.providers.BaseBrokerProvider;
import org.dd4t.providers.TaxonomyProvider;

public class BrokerTaxonomyProvider
extends BaseBrokerProvider
implements TaxonomyProvider {
    private static final String SELECT_RELATED_KEYWORDS = "select distinct(rk) from RelatedKeyword rk, ItemMeta im where rk.publicationId = :publicationId and rk.taxonomyId = :taxonomyId and im.itemType = :itemType and rk.itemId = im.itemId and rk.publicationId = im.publicationId";
    private static final String SELECT_RELATED_COMPONENTS_BY_SCHEMA = "select distinct(rk) from RelatedKeyword rk, ItemMeta im, ComponentMeta cm where rk.publicationId = :publicationId and rk.taxonomyId = :taxonomyId and im.itemType = 16 and rk.itemId = im.itemId and rk.publicationId = im.publicationId and cm.publicationId = im.publicationId and cm.itemId = im.itemId and cm.schemaId = :schemaId";

    public Keyword getTaxonomy(String taxonomyURI) throws StorageException {
        TaxonomyFactory factory = new TaxonomyFactory();
        return factory.getTaxonomyKeywords(taxonomyURI);
    }

    public List<RelatedKeyword> getRelatedItems(String taxonomyURI, int itemType) throws ParseException, StorageException {
        TCMURI taxonomyTcmUri = new TCMURI(taxonomyURI);
        int publicationId = taxonomyTcmUri.getPublicationId();
        HashMap<String, Integer> queryParams = new HashMap<String, Integer>();
        queryParams.put("publicationId", publicationId);
        queryParams.put("taxonomyId", taxonomyTcmUri.getItemId());
        queryParams.put("itemType", itemType);
        return this.getJPADAO(publicationId).executeQueryListResult(SELECT_RELATED_KEYWORDS, queryParams);
    }

    public List<RelatedKeyword> getRelatedComponentsBySchema(String taxonomyURI, String schemaURI) throws ParseException, StorageException {
        TCMURI taxonomyTcmUri = new TCMURI(taxonomyURI);
        TCMURI schemaTcmUri = new TCMURI(schemaURI);
        int publicationId = taxonomyTcmUri.getPublicationId();
        HashMap<String, Integer> queryParams = new HashMap<String, Integer>();
        queryParams.put("publicationId", publicationId);
        queryParams.put("taxonomyId", taxonomyTcmUri.getItemId());
        queryParams.put("schemaId", schemaTcmUri.getItemId());
        return this.getJPADAO(publicationId).executeQueryListResult(SELECT_RELATED_COMPONENTS_BY_SCHEMA, queryParams);
    }

    private JPABaseDAO getJPADAO(int publicationId) throws StorageException {
        BaseDAO baseDAO = StorageManagerFactory.getDAO((int)publicationId, (StorageTypeMapping)StorageTypeMapping.ITEM_META);
        boolean loop = true;
        while (loop) {
            if (baseDAO instanceof WrappableDAO) {
                WrappableDAO wrappableDAO = (WrappableDAO)baseDAO;
                baseDAO = wrappableDAO.getWrapped();
            } else {
                loop = false;
            }
            if (!(baseDAO instanceof JPABaseDAO)) continue;
            return (JPABaseDAO)baseDAO;
        }
        throw new StorageException("Cannot find JPABaseDAO. Please check your storage bindings.");
    }

    public String getTaxonomyByURI(String taxonomyURI, boolean resolveContent) throws ItemNotFoundException, SerializationException {
        throw new NotImplementedException();
    }

    public String getTaxonomyFilterBySchema(String taxonomyURI, String schemaURI) throws ItemNotFoundException, SerializationException {
        throw new NotImplementedException();
    }
}

