/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.providers.impl;

import com.tridion.broker.StorageException;
import com.tridion.dynamiccontent.DynamicContent;
import com.tridion.dynamiccontent.DynamicMetaRetriever;
import com.tridion.dynamiccontent.publication.PublicationMapping;
import com.tridion.meta.BinaryMeta;
import com.tridion.meta.PageMeta;
import com.tridion.meta.PublicationMeta;
import com.tridion.meta.PublicationMetaFactory;
import org.dd4t.core.caching.CacheElement;
import org.dd4t.core.caching.CacheType;
import org.dd4t.providers.PublicationProvider;
import org.dd4t.providers.impl.AbstractPublicationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerPublicationProvider
extends AbstractPublicationProvider
implements PublicationProvider {
    private static final DynamicMetaRetriever DYNAMIC_META_RETRIEVER = new DynamicMetaRetriever();
    private static final PublicationMetaFactory PUBLICATION_META_FACTORY = new PublicationMetaFactory();
    private static final Logger LOG = LoggerFactory.getLogger(BrokerPublicationProvider.class);

    public int discoverPublicationByBaseUrl(String fullUrl) {
        PublicationMapping publicationMapping = DynamicContent.getInstance().getMappingsResolver().getPublicationMappingFromUrl(fullUrl);
        if (publicationMapping != null) {
            return publicationMapping.getPublicationId();
        }
        LOG.info("Could not find publication Id for url: {}", (Object)fullUrl);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int discoverPublicationIdByPageUrlPath(String url) {
        LOG.debug("Discovering Publication id for url: {}", (Object)url);
        String key = this.getKey(CacheType.DISCOVER_PUBLICATION_URL, url);
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(key);
        Integer result = -1;
        if (cacheElement.isExpired()) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    PageMeta pageMeta = this.loadPageMetaByConcreteFactory(url);
                    if (pageMeta != null) {
                        result = pageMeta.getPublicationId();
                        LOG.debug("Publication Id for URL: {}, is {}", (Object)url, (Object)result);
                    } else {
                        LOG.warn("Could not resolve publication Id for URL: {}", (Object)url);
                    }
                    cacheElement.setPayload((Object)result);
                    this.cacheProvider.storeInItemCache(key, cacheElement);
                    cacheElement.setExpired(false);
                    LOG.debug("Stored Publication Id with key: {} in cache", (Object)key);
                } else {
                    LOG.debug("Fetched a Publication Id with key: {} from cache", (Object)key);
                    result = (Integer)cacheElement.getPayload();
                }
            }
        } else {
            LOG.debug("Fetched Publication Id with key: {} from cache", (Object)key);
            result = (Integer)cacheElement.getPayload();
        }
        return result == null ? -1 : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int discoverPublicationByImagesUrl(String fullUrl) {
        LOG.debug("Discovering Publication id for Binary url: {}", (Object)fullUrl);
        String key = this.getKey(CacheType.DISCOVER_IMAGES_URL, fullUrl);
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(key);
        Integer result = -1;
        if (cacheElement.isExpired()) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    BinaryMeta binaryMeta = this.loadBinaryMetaByConcreteFactory(fullUrl);
                    if (binaryMeta != null) {
                        result = binaryMeta.getPublicationId();
                        LOG.debug("Publication Id for URL: {}, is {}", (Object)fullUrl, (Object)result);
                    } else {
                        LOG.warn("Could not resolve publication Id for Binary URL: {}", (Object)fullUrl);
                    }
                    cacheElement.setPayload((Object)result);
                    this.cacheProvider.storeInItemCache(key, cacheElement);
                    cacheElement.setExpired(false);
                    LOG.debug("Stored Publication Id with key: {} in cache", (Object)key);
                } else {
                    LOG.debug("Fetched a Publication Id with key: {} from cache", (Object)key);
                    result = (Integer)cacheElement.getPayload();
                }
            }
        } else {
            LOG.debug("Fetched Publication Id for Binary with key: {} from cache", (Object)key);
            result = (Integer)cacheElement.getPayload();
        }
        return result == null ? -1 : result;
    }

    @Override
    protected PublicationMeta loadPublicationMetaByConcreteFactory(int publicationId) {
        try {
            return PUBLICATION_META_FACTORY.getMeta(publicationId);
        }
        catch (StorageException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected PageMeta loadPageMetaByConcreteFactory(String url) {
        return DYNAMIC_META_RETRIEVER.getPageMetaByURL(url);
    }

    @Override
    protected BinaryMeta loadBinaryMetaByConcreteFactory(String url) {
        return DYNAMIC_META_RETRIEVER.getBinaryMetaByURL(url);
    }
}

