/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.providers.impl;

import com.tridion.broker.StorageException;
import com.tridion.broker.querying.Query;
import com.tridion.broker.querying.criteria.Criteria;
import com.tridion.broker.querying.criteria.content.PageURLCriteria;
import com.tridion.broker.querying.criteria.content.PublicationCriteria;
import com.tridion.broker.querying.criteria.operators.AndCriteria;
import com.tridion.broker.querying.filter.LimitFilter;
import com.tridion.broker.querying.filter.ResultFilter;
import com.tridion.broker.querying.sorting.SortDirection;
import com.tridion.broker.querying.sorting.SortParameter;
import com.tridion.data.CharacterData;
import com.tridion.storage.ItemMeta;
import com.tridion.storage.PageMeta;
import com.tridion.storage.StorageManagerFactory;
import com.tridion.storage.StorageTypeMapping;
import com.tridion.storage.dao.ItemDAO;
import com.tridion.storage.dao.ItemTypeSelector;
import com.tridion.storage.dao.PageDAO;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.dd4t.core.caching.CacheElement;
import org.dd4t.core.caching.CacheType;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.core.util.Constants;
import org.dd4t.core.util.TCMURI;
import org.dd4t.providers.BaseBrokerProvider;
import org.dd4t.providers.PageProvider;
import org.dd4t.providers.ProviderResultItem;
import org.dd4t.providers.StringResultItemImpl;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerPageProvider
extends BaseBrokerProvider
implements PageProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerPageProvider.class);

    public ProviderResultItem<String> getPageById(int id, int publication) throws IOException, ItemNotFoundException, SerializationException {
        PageMeta pageMeta = this.getPageMetaById(id, publication);
        StringResultItemImpl pageResult = new StringResultItemImpl();
        if (pageMeta == null) {
            throw new ItemNotFoundException("Unable to find page meta by id '" + id + "' and publication '" + publication + "'.");
        }
        pageResult.setLastPublishDate(pageMeta.getLastPublishDate());
        pageResult.setRevisionDate(pageMeta.getModificationDate());
        pageResult.setContentSource((Object)this.getPageContentById(id, publication));
        return pageResult;
    }

    public ProviderResultItem<String> getPageByURL(String url, int publication) throws ItemNotFoundException, SerializationException {
        PageMeta pageMeta = this.getPageMetaByURL(url, publication);
        StringResultItemImpl pageResult = new StringResultItemImpl();
        if (pageMeta == null) {
            throw new ItemNotFoundException("Unable to find page meta by url '" + url + "' and publication '" + publication + "'.");
        }
        pageResult.setLastPublishDate(pageMeta.getLastPublishDate());
        pageResult.setRevisionDate(pageMeta.getModificationDate());
        pageResult.setContentSource((Object)this.getPageContentById(pageMeta.getItemId(), pageMeta.getPublicationId()));
        return pageResult;
    }

    public String getPageContentById(int id, int publication) throws ItemNotFoundException, SerializationException {
        CharacterData data = null;
        try {
            PageDAO pageDAO = (PageDAO)StorageManagerFactory.getDAO((int)publication, (StorageTypeMapping)StorageTypeMapping.PAGE);
            data = pageDAO.findByPrimaryKey(publication, id);
        }
        catch (StorageException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (data == null) {
            throw new ItemNotFoundException("Unable to find page by id '" + id + "' and publication '" + publication + "'.");
        }
        try {
            return this.decodeAndDecompressContent(BrokerPageProvider.convertStreamToString((InputStream)data.getInputStream()));
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public String getPageContentByURL(String url, int publication) throws ItemNotFoundException, SerializationException {
        PageMeta meta = this.getPageMetaByURL(url, publication);
        return this.getPageContentById(meta.getItemId(), meta.getPublicationId());
    }

    public String getPageContentById(String tcmUri) throws ItemNotFoundException, ParseException, SerializationException {
        TCMURI uri = new TCMURI(tcmUri);
        return this.getPageContentById(uri.getItemId(), uri.getPublicationId());
    }

    public PageMeta getPageMetaById(int id, int publication) throws ItemNotFoundException {
        PageMeta meta = null;
        try {
            ItemDAO itemDAO = (ItemDAO)StorageManagerFactory.getDAO((int)publication, (StorageTypeMapping)StorageTypeMapping.PAGE_META);
            meta = (PageMeta)itemDAO.findByPrimaryKey(publication, id);
        }
        catch (StorageException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (meta == null) {
            throw new ItemNotFoundException("Unable to find page by id '" + id + "' and publication '" + publication + "'.");
        }
        return meta;
    }

    public PageMeta getPageMetaByURL(String url, int publication) throws ItemNotFoundException {
        PageMeta meta = null;
        try {
            ItemDAO itemDAO = (ItemDAO)StorageManagerFactory.getDAO((int)publication, (StorageTypeMapping)StorageTypeMapping.PAGE_META);
            meta = itemDAO.findByPageURL(publication, url);
        }
        catch (StorageException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (meta == null) {
            throw new ItemNotFoundException("Unable to find page by url '" + url + "' and publication '" + publication + "'.");
        }
        return meta;
    }

    public String getPageListByPublicationId(int publication) throws ItemNotFoundException {
        List itemMetas = null;
        try {
            ItemDAO itemDAO = (ItemDAO)StorageManagerFactory.getDAO((int)publication, (StorageTypeMapping)StorageTypeMapping.PAGE_META);
            itemMetas = itemDAO.findAll(publication, ItemTypeSelector.PAGE);
        }
        catch (StorageException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (itemMetas == null || itemMetas.isEmpty()) {
            throw new ItemNotFoundException("Unable to find page URL list by publication '" + publication + "'.");
        }
        StringBuilder result = new StringBuilder();
        for (ItemMeta itemMeta : itemMetas) {
            result.append(((PageMeta)itemMeta).getUrl()).append("\r\n");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPageExists(String url, int publicationId) throws ItemNotFoundException, SerializationException {
        LOG.debug("Checking whether Page with url: {} exists", (Object)url);
        String key = this.getKey(CacheType.PAGE_EXISTS, url);
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(key);
        Integer result = null;
        if (cacheElement.isExpired()) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    PublicationCriteria publicationCriteria = new PublicationCriteria(publicationId);
                    PageURLCriteria pageURLCriteria = new PageURLCriteria(url);
                    Query tridionQuery = new Query((Criteria)new AndCriteria((Criteria)publicationCriteria, (Criteria)pageURLCriteria));
                    tridionQuery.setResultFilter((ResultFilter)new LimitFilter(1));
                    tridionQuery.addSorting(new SortParameter(SortParameter.ITEMS_URL, SortDirection.DESCENDING));
                    try {
                        String[] results = tridionQuery.executeQuery();
                        if (results != null && results.length > 0) {
                            result = 1;
                            TCMURI tcmuri = new TCMURI(results[0]);
                            cacheElement.setPayload((Object)result);
                            this.cacheProvider.storeInItemCache(key, cacheElement, tcmuri.getPublicationId(), tcmuri.getItemId());
                            cacheElement.setExpired(false);
                        } else {
                            result = 0;
                            cacheElement.setPayload((Object)result);
                            this.cacheProvider.storeInItemCache(key, cacheElement);
                            cacheElement.setExpired(false);
                        }
                    }
                    catch (StorageException | ParseException e) {
                        LOG.error(e.getLocalizedMessage(), e);
                    }
                    LOG.debug("Stored Page exist check with key: {} in cache", (Object)key);
                } else {
                    LOG.debug("Fetched a Page exist check with key: {} from cache", (Object)key);
                    result = (Integer)cacheElement.getPayload();
                }
            }
        }
        LOG.debug("Fetched Page exist check with key: {} from cache", (Object)key);
        result = (Integer)cacheElement.getPayload();
        return result != null && result == 1;
    }

    public TCMURI getPageIdForUrl(String url, int publicationId) throws ItemNotFoundException, SerializationException {
        PageMeta pageMeta = this.getPageMetaByURL(url, publicationId);
        if (pageMeta != null) {
            return new TCMURI(publicationId, pageMeta.getItemId(), pageMeta.getItemType(), pageMeta.getMajorVersion().intValue());
        }
        throw new ItemNotFoundException("Page Id for URL not found.");
    }

    public DateTime getLastPublishDate(String url, int publication) throws ItemNotFoundException {
        PageMeta pageMeta = this.getPageMetaByURL(url, publication);
        Date lpd = pageMeta.getLastPublishDate();
        return lpd != null ? new DateTime((Object)pageMeta.getLastPublishDate()) : Constants.THE_YEAR_ZERO;
    }
}

