/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.providers.impl;

import com.tridion.dcp.ComponentPresentation;
import com.tridion.dcp.ComponentPresentationFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.providers.AbstractComponentPresentationProvider;
import org.dd4t.providers.ComponentPresentationProvider;

public class BrokerComponentPresentationProvider
extends AbstractComponentPresentationProvider
implements ComponentPresentationProvider {
    private static final Map<Integer, ComponentPresentationFactory> FACTORY_CACHE = new ConcurrentHashMap<Integer, ComponentPresentationFactory>();

    public String getDynamicComponentPresentation(int componentId, int publicationId) throws ItemNotFoundException, SerializationException {
        return this.getDynamicComponentPresentation(componentId, 0, publicationId);
    }

    public String getDynamicComponentPresentation(int componentId, int templateId, int publicationId) throws ItemNotFoundException, SerializationException {
        ComponentPresentationFactory factory = FACTORY_CACHE.get(publicationId);
        if (factory == null) {
            factory = new ComponentPresentationFactory(publicationId);
            FACTORY_CACHE.put(publicationId, factory);
        }
        ComponentPresentation result = templateId != 0 ? factory.getComponentPresentation(componentId, templateId) : factory.getComponentPresentationWithHighestPriority(componentId);
        BrokerComponentPresentationProvider.assertQueryResultNotNull((Object)result, (int)componentId, (int)templateId, (int)publicationId);
        String resultString = result.getContent();
        if (!StringUtils.isEmpty((CharSequence)resultString)) {
            return this.decodeAndDecompressContent(resultString);
        }
        return null;
    }
}

