/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.providers.impl;

import com.tridion.broker.StorageException;
import com.tridion.storage.BinaryContent;
import com.tridion.storage.BinaryVariant;
import com.tridion.storage.StorageManagerFactory;
import com.tridion.storage.StorageTypeMapping;
import com.tridion.storage.dao.BinaryContentDAO;
import com.tridion.storage.dao.BinaryVariantDAO;
import java.text.ParseException;
import java.util.Date;
import org.dd4t.contentmodel.Binary;
import org.dd4t.contentmodel.BinaryData;
import org.dd4t.contentmodel.impl.BinaryDataImpl;
import org.dd4t.contentmodel.impl.BinaryImpl;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.core.util.Constants;
import org.dd4t.core.util.TCMURI;
import org.dd4t.providers.BaseBrokerProvider;
import org.dd4t.providers.BinaryProvider;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerBinaryProvider
extends BaseBrokerProvider
implements BinaryProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerBinaryProvider.class);

    public Binary getBinaryByURI(String tcmUri) throws ItemNotFoundException, ParseException, SerializationException {
        TCMURI binaryUri = new TCMURI(tcmUri);
        BinaryVariant binaryVariant = this.getBinaryVariantById(binaryUri.getItemId(), binaryUri.getPublicationId());
        return BrokerBinaryProvider.getBinary(binaryUri, binaryVariant);
    }

    public Binary getBinaryByURL(String url, int publication) throws ItemNotFoundException, SerializationException {
        BinaryVariant binaryVariant = this.getBinaryVariantByURL(url, publication);
        if (binaryVariant == null) {
            throw new ItemNotFoundException("Unable to find binary content by URL '" + url + "' and publication '" + publication + "'.");
        }
        TCMURI binaryUri = new TCMURI(binaryVariant.getBinaryMeta().getPublicationId(), binaryVariant.getBinaryMeta().getItemId(), 16);
        return BrokerBinaryProvider.getBinary(binaryUri, binaryVariant);
    }

    private static Binary getBinary(TCMURI binaryUri, BinaryVariant binaryVariant) throws ItemNotFoundException {
        if (binaryVariant != null) {
            BinaryImpl binary = new BinaryImpl();
            binary.setId(binaryUri.toString());
            binary.setUrlPath(binaryVariant.getUrl());
            binary.setMimeType(binaryVariant.getBinaryType());
            if (binaryVariant.getBinaryMeta() != null) {
                Date lastPublishDate = binaryVariant.getBinaryMeta().getMultimediaMeta().getLastPublishDate();
                if (lastPublishDate != null) {
                    binary.setLastPublishedDate(new DateTime((Object)lastPublishDate));
                } else {
                    binary.setLastPublishedDate(Constants.THE_YEAR_ZERO);
                }
                Date revisionDate = binaryVariant.getBinaryMeta().getMultimediaMeta().getModificationDate();
                if (revisionDate != null) {
                    binary.setRevisionDate(new DateTime((Object)revisionDate));
                } else {
                    binary.setRevisionDate(Constants.THE_YEAR_ZERO);
                }
            }
            BinaryContent content = null;
            try {
                BinaryContentDAO contentDAO = (BinaryContentDAO)StorageManagerFactory.getDAO((int)binaryUri.getPublicationId(), (StorageTypeMapping)StorageTypeMapping.BINARY_CONTENT);
                content = contentDAO.findByPrimaryKey(binaryUri.getPublicationId(), binaryUri.getItemId(), null);
            }
            catch (StorageException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            if (content == null) {
                throw new ItemNotFoundException("Unable to find binary content by id:" + binaryUri.toString());
            }
            BinaryDataImpl binaryData = new BinaryDataImpl();
            binaryData.setBytes((byte[])content.getContent().clone());
            binary.setBinaryData((BinaryData)binaryData);
            return binary;
        }
        return null;
    }

    public byte[] getBinaryContentById(int id, int publication) throws ItemNotFoundException {
        BinaryContent content = null;
        try {
            BinaryContentDAO contentDAO = (BinaryContentDAO)StorageManagerFactory.getDAO((int)publication, (StorageTypeMapping)StorageTypeMapping.BINARY_CONTENT);
            content = contentDAO.findByPrimaryKey(publication, id, null);
        }
        catch (StorageException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (content == null) {
            throw new ItemNotFoundException("Unable to find binary content by id '" + id + "' and publication '" + publication + "'.");
        }
        return content.getContent();
    }

    public byte[] getBinaryContentByURL(String url, int publication) throws ItemNotFoundException {
        BinaryVariant variant = this.getBinaryVariantByURL(url, publication);
        return this.getBinaryContentById(variant.getBinaryId(), variant.getPublicationId());
    }

    public BinaryVariant getBinaryVariantById(int id, int publication) throws ItemNotFoundException {
        BinaryVariant variant = null;
        try {
            BinaryVariantDAO variantDAO = (BinaryVariantDAO)StorageManagerFactory.getDAO((int)publication, (StorageTypeMapping)StorageTypeMapping.BINARY_VARIANT);
            variant = variantDAO.findByPrimaryKey(publication, id, null);
        }
        catch (StorageException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (variant == null) {
            throw new ItemNotFoundException("Unable to find binary by id '" + id + "' and publication '" + publication + "'.");
        }
        return variant;
    }

    public BinaryVariant getBinaryVariantByURL(String url, int publication) throws ItemNotFoundException {
        BinaryVariant variant = null;
        try {
            BinaryVariantDAO variantDAO = (BinaryVariantDAO)StorageManagerFactory.getDAO((int)publication, (StorageTypeMapping)StorageTypeMapping.BINARY_VARIANT);
            variant = variantDAO.findByURL(publication, url);
        }
        catch (StorageException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (variant == null) {
            throw new ItemNotFoundException("Unable to find binary by url '" + url + "' and publication '" + publication + "'.");
        }
        return variant;
    }

    public DateTime getLastPublishDate(String tcmUri) throws ParseException, ItemNotFoundException {
        Date lpd;
        TCMURI binaryTcmUri = new TCMURI(tcmUri);
        BinaryVariant variant = this.getBinaryVariantById(binaryTcmUri.getItemId(), binaryTcmUri.getPublicationId());
        if (variant != null && variant.getBinaryMeta() != null && (lpd = variant.getBinaryMeta().getMultimediaMeta().getLastPublishDate()) != null) {
            return new DateTime((Object)lpd);
        }
        return new DateTime(0, 0, 0, 0, 0);
    }
}

