/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.providers.impl;

import com.tridion.meta.BinaryMeta;
import com.tridion.meta.PageMeta;
import com.tridion.meta.PublicationMeta;
import org.dd4t.contentmodel.PublicationDescriptor;
import org.dd4t.core.caching.CacheElement;
import org.dd4t.core.caching.CacheType;
import org.dd4t.providers.BaseBrokerProvider;
import org.dd4t.providers.PublicationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPublicationProvider
extends BaseBrokerProvider
implements PublicationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPublicationProvider.class);
    protected Class publicationDescriptor;

    public String discoverPublicationUrl(int publicationId) {
        PublicationMeta publicationMeta = this.getPublicationMeta(publicationId);
        if (publicationMeta == null) {
            return null;
        }
        return publicationMeta.getPublicationUrl();
    }

    public String discoverPublicationPath(int publicationId) {
        PublicationMeta publicationMeta = this.getPublicationMeta(publicationId);
        if (publicationMeta == null) {
            return null;
        }
        return publicationMeta.getPublicationPath();
    }

    public String discoverImagesUrl(int publicationId) {
        PublicationMeta publicationMeta = this.getPublicationMeta(publicationId);
        if (publicationMeta == null) {
            return null;
        }
        return publicationMeta.getMultimediaUrl();
    }

    public String discoverImagesPath(int publicationId) {
        PublicationMeta publicationMeta = this.getPublicationMeta(publicationId);
        if (publicationMeta == null) {
            return null;
        }
        return publicationMeta.getMultimediaPath();
    }

    public String discoverPublicationTitle(int publicationId) {
        PublicationMeta publicationMeta = this.getPublicationMeta(publicationId);
        if (publicationMeta == null) {
            return null;
        }
        return publicationMeta.getTitle();
    }

    public String discoverPublicationKey(int publicationId) {
        PublicationMeta publicationMeta = this.getPublicationMeta(publicationId);
        if (publicationMeta == null) {
            return null;
        }
        return publicationMeta.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PublicationMeta getPublicationMeta(int publicationId) {
        PublicationMeta publicationMeta;
        String key = this.getKey(CacheType.PUBLICATION_META, Integer.toString(publicationId));
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(key);
        if (cacheElement.isExpired()) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    publicationMeta = this.loadPublicationMetaByConcreteFactory(publicationId);
                    if (publicationMeta != null) {
                        cacheElement.setPayload((Object)publicationMeta);
                        this.cacheProvider.storeInItemCache(key, cacheElement);
                        cacheElement.setExpired(false);
                        LOG.debug("Stored Publication Meta with key: {} in cache", (Object)key);
                    } else {
                        LOG.warn("No Publication Meta found for publication Id: {}", (Object)publicationId);
                    }
                } else {
                    LOG.debug("Fetched a Publication Meta with key: {} from cache", (Object)key);
                    publicationMeta = (PublicationMeta)cacheElement.getPayload();
                }
            }
        } else {
            LOG.debug("Fetched a Publication Meta with key: {} from cache", (Object)key);
            publicationMeta = (PublicationMeta)cacheElement.getPayload();
        }
        if (publicationMeta == null) {
            LOG.error("Could not find Publication Meta for publication id: {}", (Object)publicationId);
            return null;
        }
        return publicationMeta;
    }

    public PublicationDescriptor getPublicationDescriptor(int publicationId) {
        PublicationMeta publicationMeta = this.getPublicationMeta(publicationId);
        if (publicationMeta == null) {
            return null;
        }
        try {
            PublicationDescriptor concretePublicationDescriptor = (PublicationDescriptor)this.publicationDescriptor.newInstance();
            concretePublicationDescriptor.setId(publicationMeta.getId());
            concretePublicationDescriptor.setKey(publicationMeta.getKey());
            concretePublicationDescriptor.setPublicationUrl(publicationMeta.getPublicationUrl());
            concretePublicationDescriptor.setPublicationPath(publicationMeta.getPublicationPath());
            concretePublicationDescriptor.setMultimediaUrl(publicationMeta.getMultimediaUrl());
            concretePublicationDescriptor.setMultimediaPath(publicationMeta.getMultimediaPath());
            concretePublicationDescriptor.setTitle(publicationMeta.getTitle());
            return concretePublicationDescriptor;
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public void setPublicationDescriptor(Class publicationDescriptor) {
        this.publicationDescriptor = publicationDescriptor;
    }

    public Class getPublicationDescriptor() {
        return this.publicationDescriptor;
    }

    protected abstract PageMeta loadPageMetaByConcreteFactory(String var1);

    protected abstract PublicationMeta loadPublicationMetaByConcreteFactory(int var1);

    protected abstract BinaryMeta loadBinaryMetaByConcreteFactory(String var1);
}

