/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ndarray;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.datavec.api.transform.Distance;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class NDArrayDistanceTransform
implements Transform {
    private String newColumnName;
    private Distance distance;
    private String firstCol;
    private String secondCol;
    private Schema inputSchema;

    public NDArrayDistanceTransform(@JsonProperty(value="newColumnName") @NonNull String newColumnName, @JsonProperty(value="distance") @NonNull Distance distance, @JsonProperty(value="firstCol") @NonNull String firstCol, @JsonProperty(value="secondCol") @NonNull String secondCol) {
        if (newColumnName == null) {
            throw new NullPointerException("newColumnName is marked non-null but is null");
        }
        if (distance == null) {
            throw new NullPointerException("distance is marked non-null but is null");
        }
        if (firstCol == null) {
            throw new NullPointerException("firstCol is marked non-null but is null");
        }
        if (secondCol == null) {
            throw new NullPointerException("secondCol is marked non-null but is null");
        }
        this.newColumnName = newColumnName;
        this.distance = distance;
        this.firstCol = firstCol;
        this.secondCol = secondCol;
    }

    public String toString() {
        return "NDArrayDistanceTransform(newColumnName=\"" + this.newColumnName + "\",distance=" + (Object)((Object)this.distance) + ",firstCol=" + this.firstCol + ",secondCol=" + this.secondCol + ")";
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        if (!inputSchema.hasColumn(this.firstCol)) {
            throw new IllegalStateException("Input schema does not have first column: " + this.firstCol);
        }
        if (!inputSchema.hasColumn(this.secondCol)) {
            throw new IllegalStateException("Input schema does not have first column: " + this.secondCol);
        }
        this.inputSchema = inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        double d;
        int idxFirst = this.inputSchema.getIndexOfColumn(this.firstCol);
        int idxSecond = this.inputSchema.getIndexOfColumn(this.secondCol);
        INDArray arr1 = ((NDArrayWritable)writables.get(idxFirst)).get();
        INDArray arr2 = ((NDArrayWritable)writables.get(idxSecond)).get();
        switch (this.distance) {
            case COSINE: {
                d = Transforms.cosineSim((INDArray)arr1, (INDArray)arr2);
                break;
            }
            case EUCLIDEAN: {
                d = Transforms.euclideanDistance((INDArray)arr1, (INDArray)arr2);
                break;
            }
            case MANHATTAN: {
                d = Transforms.manhattanDistance((INDArray)arr1, (INDArray)arr2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown or not supported distance metric: " + (Object)((Object)this.distance));
            }
        }
        ArrayList<Writable> out = new ArrayList<Writable>(writables.size() + 1);
        out.addAll(writables);
        out.add(new DoubleWritable(d));
        return out;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (List<Writable> l : sequence) {
            out.add(this.map(l));
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Schema transform(Schema inputSchema) {
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(inputSchema.getColumnMetaData());
        newMeta.add(new DoubleMetaData(this.newColumnName));
        return inputSchema.newSchema(newMeta);
    }

    @Override
    public String outputColumnName() {
        return this.newColumnName;
    }

    @Override
    public String[] outputColumnNames() {
        return new String[]{this.outputColumnName()};
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.firstCol, this.secondCol};
    }

    @Override
    public String columnName() {
        return this.columnNames()[0];
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public Distance getDistance() {
        return this.distance;
    }

    public String getFirstCol() {
        return this.firstCol;
    }

    public String getSecondCol() {
        return this.secondCol;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    public void setNewColumnName(String newColumnName) {
        this.newColumnName = newColumnName;
    }

    public void setDistance(Distance distance) {
        this.distance = distance;
    }

    public void setFirstCol(String firstCol) {
        this.firstCol = firstCol;
    }

    public void setSecondCol(String secondCol) {
        this.secondCol = secondCol;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NDArrayDistanceTransform)) {
            return false;
        }
        NDArrayDistanceTransform other = (NDArrayDistanceTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$newColumnName = this.getNewColumnName();
        String other$newColumnName = other.getNewColumnName();
        if (this$newColumnName == null ? other$newColumnName != null : !this$newColumnName.equals(other$newColumnName)) {
            return false;
        }
        Distance this$distance = this.getDistance();
        Distance other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)((Object)this$distance)).equals((Object)other$distance)) {
            return false;
        }
        String this$firstCol = this.getFirstCol();
        String other$firstCol = other.getFirstCol();
        if (this$firstCol == null ? other$firstCol != null : !this$firstCol.equals(other$firstCol)) {
            return false;
        }
        String this$secondCol = this.getSecondCol();
        String other$secondCol = other.getSecondCol();
        if (this$secondCol == null ? other$secondCol != null : !this$secondCol.equals(other$secondCol)) {
            return false;
        }
        Schema this$inputSchema = this.getInputSchema();
        Schema other$inputSchema = other.getInputSchema();
        return !(this$inputSchema == null ? other$inputSchema != null : !((Object)this$inputSchema).equals(other$inputSchema));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NDArrayDistanceTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $newColumnName = this.getNewColumnName();
        result = result * 59 + ($newColumnName == null ? 43 : $newColumnName.hashCode());
        Distance $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)((Object)$distance)).hashCode());
        String $firstCol = this.getFirstCol();
        result = result * 59 + ($firstCol == null ? 43 : $firstCol.hashCode());
        String $secondCol = this.getSecondCol();
        result = result * 59 + ($secondCol == null ? 43 : $secondCol.hashCode());
        Schema $inputSchema = this.getInputSchema();
        result = result * 59 + ($inputSchema == null ? 43 : ((Object)$inputSchema).hashCode());
        return result;
    }
}

