/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ndarray;

import java.util.Arrays;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.NDArrayMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseColumnsMathOpTransform;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class NDArrayColumnsMathOpTransform
extends BaseColumnsMathOpTransform {
    public NDArrayColumnsMathOpTransform(@JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="mathOp") MathOp mathOp, String ... columns) {
        super(newColumnName, mathOp, columns);
    }

    @Override
    protected ColumnMetaData derivedColumnMetaData(String newColumnName, Schema inputSchema) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (inputSchema.getMetaData(this.columns[i]).getColumnType() == ColumnType.NDArray) continue;
            throw new RuntimeException("Column " + this.columns[i] + " is not an NDArray column");
        }
        NDArrayMetaData meta = (NDArrayMetaData)inputSchema.getMetaData(this.columns[0]);
        for (int i = 1; i < this.columns.length; ++i) {
            NDArrayMetaData meta2 = (NDArrayMetaData)inputSchema.getMetaData(this.columns[i]);
            if (Arrays.equals(meta.getShape(), meta2.getShape())) continue;
            throw new UnsupportedOperationException("Cannot perform NDArray operation on columns with different shapes: Columns \"" + this.columns[0] + "\" and \"" + this.columns[i] + "\" have shapes: " + Arrays.toString(meta.getShape()) + " and " + Arrays.toString(meta2.getShape()));
        }
        return new NDArrayMetaData(newColumnName, meta.getShape());
    }

    @Override
    protected Writable doOp(Writable ... input) {
        INDArray out = ((NDArrayWritable)input[0]).get().dup();
        switch (this.mathOp) {
            case Add: {
                for (int i = 1; i < input.length; ++i) {
                    out.addi(((NDArrayWritable)input[i]).get());
                }
                break;
            }
            case Subtract: {
                out.subi(((NDArrayWritable)input[1]).get());
                break;
            }
            case Multiply: {
                for (int i = 1; i < input.length; ++i) {
                    out.muli(((NDArrayWritable)input[i]).get());
                }
                break;
            }
            case Divide: {
                out.divi(((NDArrayWritable)input[1]).get());
                break;
            }
            case ReverseSubtract: {
                out.rsubi(((NDArrayWritable)input[1]).get());
                break;
            }
            case ReverseDivide: {
                out.rdivi(((NDArrayWritable)input[1]).get());
                break;
            }
            case Modulus: 
            case ScalarMin: 
            case ScalarMax: {
                throw new IllegalArgumentException("Invalid MathOp: cannot use " + (Object)((Object)this.mathOp) + " with NDArrayColumnsMathOpTransform");
            }
            default: {
                throw new RuntimeException("Unknown MathOp: " + (Object)((Object)this.mathOp));
            }
        }
        Nd4j.getExecutioner().commit();
        return new NDArrayWritable(out);
    }

    @Override
    public String toString() {
        return "NDArrayColumnsMathOpTransform(newColumnName=\"" + this.newColumnName + "\",mathOp=" + (Object)((Object)this.mathOp) + ",columns=" + Arrays.toString(this.columns) + ")";
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NDArrayColumnsMathOpTransform)) {
            return false;
        }
        NDArrayColumnsMathOpTransform other = (NDArrayColumnsMathOpTransform)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NDArrayColumnsMathOpTransform;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

