/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import java.util.List;
import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.ColumnCondition;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"columnIdx", "schema", "sequenceMode"})
public abstract class BaseColumnCondition
implements ColumnCondition {
    protected final String columnName;
    protected int columnIdx = -1;
    protected Schema schema;
    protected SequenceConditionMode sequenceMode;

    protected BaseColumnCondition(String columnName, SequenceConditionMode sequenceConditionMode) {
        this.columnName = columnName;
        this.sequenceMode = sequenceConditionMode;
    }

    @Override
    public void setInputSchema(Schema schema) {
        this.columnIdx = schema.getColumnNames().indexOf(this.columnName);
        if (this.columnIdx < 0) {
            throw new IllegalStateException("Invalid state: column \"" + this.columnName + "\" not present in input schema");
        }
        this.schema = schema;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        return inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.schema;
    }

    @Override
    public boolean condition(List<Writable> list) {
        return this.columnCondition(list.get(this.columnIdx));
    }

    @Override
    public boolean conditionSequence(List<List<Writable>> list) {
        switch (this.sequenceMode) {
            case And: {
                for (List<Writable> l : list) {
                    if (this.condition(l)) continue;
                    return false;
                }
                return true;
            }
            case Or: {
                for (List<Writable> l : list) {
                    if (!this.condition(l)) continue;
                    return true;
                }
                return false;
            }
            case NoSequenceMode: {
                throw new IllegalStateException("Column condition " + this.toString() + " does not support sequence execution");
            }
        }
        throw new RuntimeException("Unknown/not implemented sequence mode: " + (Object)((Object)this.sequenceMode));
    }

    @Override
    public boolean conditionSequence(Object list) {
        List objects = (List)list;
        switch (this.sequenceMode) {
            case And: {
                for (Object l : objects) {
                    if (this.condition(l)) continue;
                    return false;
                }
                return true;
            }
            case Or: {
                for (Object l : objects) {
                    if (!this.condition(l)) continue;
                    return true;
                }
                return false;
            }
            case NoSequenceMode: {
                throw new IllegalStateException("Column condition " + this.toString() + " does not support sequence execution");
            }
        }
        throw new RuntimeException("Unknown/not implemented sequence mode: " + (Object)((Object)this.sequenceMode));
    }

    @Override
    public String outputColumnName() {
        return this.columnName();
    }

    @Override
    public String[] outputColumnNames() {
        return this.columnNames();
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.columnName};
    }

    @Override
    public String columnName() {
        return this.columnNames()[0];
    }

    public abstract String toString();

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseColumnCondition)) {
            return false;
        }
        BaseColumnCondition other = (BaseColumnCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        return !(this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseColumnCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        return result;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnIdx() {
        return this.columnIdx;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public SequenceConditionMode getSequenceMode() {
        return this.sequenceMode;
    }

    public void setColumnIdx(int columnIdx) {
        this.columnIdx = columnIdx;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setSequenceMode(SequenceConditionMode sequenceMode) {
        this.sequenceMode = sequenceMode;
    }
}

