/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.quality.longq;

import java.io.Serializable;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.quality.columns.LongQuality;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.common.function.BiFunction;

public class LongQualityAddFunction
implements BiFunction<LongQuality, Writable, LongQuality>,
Serializable {
    private final LongMetaData meta;

    public LongQuality apply(LongQuality v1, Writable writable) {
        long valid = v1.getCountValid();
        long invalid = v1.getCountInvalid();
        long countMissing = v1.getCountMissing();
        long countTotal = v1.getCountTotal() + 1L;
        long nonLong = v1.getCountNonLong();
        if (this.meta.isValid(writable)) {
            ++valid;
        } else if (writable instanceof NullWritable || writable instanceof Text && (writable.toString() == null || writable.toString().isEmpty())) {
            ++countMissing;
        } else {
            ++invalid;
        }
        String str = writable.toString();
        try {
            Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            ++nonLong;
        }
        return new LongQuality(valid, invalid, countMissing, countTotal, nonLong);
    }

    public LongQualityAddFunction(LongMetaData meta) {
        this.meta = meta;
    }
}

