/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.split;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import lombok.NonNull;
import org.datavec.api.split.BaseInputSplit;
import org.nd4j.common.collection.CompactHeapStringList;

public class TransformSplit
extends BaseInputSplit {
    private final BaseInputSplit sourceSplit;
    private final URITransform transform;

    public TransformSplit(@NonNull BaseInputSplit sourceSplit, @NonNull URITransform transform) throws URISyntaxException {
        if (sourceSplit == null) {
            throw new NullPointerException("sourceSplit is marked non-null but is null");
        }
        if (transform == null) {
            throw new NullPointerException("transform is marked non-null but is null");
        }
        this.sourceSplit = sourceSplit;
        this.transform = transform;
        this.initialize();
    }

    public static TransformSplit ofSearchReplace(@NonNull BaseInputSplit sourceSplit, final @NonNull String search, final @NonNull String replace) throws URISyntaxException {
        if (sourceSplit == null) {
            throw new NullPointerException("sourceSplit is marked non-null but is null");
        }
        if (search == null) {
            throw new NullPointerException("search is marked non-null but is null");
        }
        if (replace == null) {
            throw new NullPointerException("replace is marked non-null but is null");
        }
        return new TransformSplit(sourceSplit, new URITransform(){

            @Override
            public URI apply(URI uri) throws URISyntaxException {
                return new URI(uri.toString().replace(search, replace));
            }
        });
    }

    private void initialize() throws URISyntaxException {
        this.length = this.sourceSplit.length();
        this.uriStrings = new CompactHeapStringList();
        Iterator<URI> iter = this.sourceSplit.locationsIterator();
        while (iter.hasNext()) {
            URI uri = iter.next();
            uri = this.transform.apply(uri);
            this.uriStrings.add(uri.toString());
        }
    }

    @Override
    public void updateSplitLocations(boolean reset) {
        this.sourceSplit.updateSplitLocations(reset);
    }

    @Override
    public boolean needsBootstrapForWrite() {
        return this.sourceSplit.needsBootstrapForWrite();
    }

    @Override
    public void bootStrapForWrite() {
        this.sourceSplit.bootStrapForWrite();
    }

    @Override
    public OutputStream openOutputStreamFor(String location) throws Exception {
        return this.sourceSplit.openOutputStreamFor(location);
    }

    @Override
    public InputStream openInputStreamFor(String location) throws Exception {
        return this.sourceSplit.openInputStreamFor(location);
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    public static interface URITransform {
        public URI apply(URI var1) throws URISyntaxException;
    }
}

