/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.metadata;

import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.datavec.api.records.metadata.RecordMetaData;

public class RecordMetaDataLine
implements RecordMetaData {
    private int lineNumber;
    private URI uri;
    private Class<?> readerClass;

    @Override
    public String getLocation() {
        String filename;
        if (this.uri != null) {
            String str = this.uri.toString();
            filename = FilenameUtils.getBaseName((String)str) + "." + FilenameUtils.getExtension((String)str) + " ";
        } else {
            filename = "";
        }
        return filename + "line " + this.lineNumber;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Class<?> getReaderClass() {
        return this.readerClass;
    }

    public RecordMetaDataLine(int lineNumber, URI uri, Class<?> readerClass) {
        this.lineNumber = lineNumber;
        this.uri = uri;
        this.readerClass = readerClass;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setReaderClass(Class<?> readerClass) {
        this.readerClass = readerClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordMetaDataLine)) {
            return false;
        }
        RecordMetaDataLine other = (RecordMetaDataLine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLineNumber() != other.getLineNumber()) {
            return false;
        }
        URI this$uri = this.getURI();
        URI other$uri = other.getURI();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        Class<?> this$readerClass = this.getReaderClass();
        Class<?> other$readerClass = other.getReaderClass();
        return !(this$readerClass == null ? other$readerClass != null : !this$readerClass.equals(other$readerClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordMetaDataLine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLineNumber();
        URI $uri = this.getURI();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        Class<?> $readerClass = this.getReaderClass();
        result = result * 59 + ($readerClass == null ? 43 : $readerClass.hashCode());
        return result;
    }

    public String toString() {
        return "RecordMetaDataLine(lineNumber=" + this.getLineNumber() + ", uri=" + this.getURI() + ", readerClass=" + this.getReaderClass() + ")";
    }
}

