/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.metadata;

import java.net.URI;
import java.util.Map;
import org.datavec.api.records.metadata.RecordMetaData;

public class RecordMetaDataComposableMap
implements RecordMetaData {
    private Class<?> readerClass;
    private Map<String, RecordMetaData> meta;

    public RecordMetaDataComposableMap(Map<String, RecordMetaData> recordMetaDatas) {
        this(null, recordMetaDatas);
    }

    public RecordMetaDataComposableMap(Class<?> readerClass, Map<String, RecordMetaData> recordMetaDatas) {
        this.readerClass = readerClass;
        this.meta = recordMetaDatas;
    }

    @Override
    public String getLocation() {
        StringBuilder sb = new StringBuilder();
        sb.append("locations(");
        boolean first = true;
        for (Map.Entry<String, RecordMetaData> rmd : this.meta.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append(rmd.getKey()).append("=");
            sb.append(rmd.getValue().getLocation());
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public URI getURI() {
        String first = this.meta.keySet().iterator().next();
        return this.meta.get(first).getURI();
    }

    @Override
    public Class<?> getReaderClass() {
        return this.readerClass;
    }

    public Map<String, RecordMetaData> getMeta() {
        return this.meta;
    }

    public void setReaderClass(Class<?> readerClass) {
        this.readerClass = readerClass;
    }

    public void setMeta(Map<String, RecordMetaData> meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordMetaDataComposableMap)) {
            return false;
        }
        RecordMetaDataComposableMap other = (RecordMetaDataComposableMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$readerClass = this.getReaderClass();
        Class<?> other$readerClass = other.getReaderClass();
        if (this$readerClass == null ? other$readerClass != null : !this$readerClass.equals(other$readerClass)) {
            return false;
        }
        Map<String, RecordMetaData> this$meta = this.getMeta();
        Map<String, RecordMetaData> other$meta = other.getMeta();
        return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordMetaDataComposableMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $readerClass = this.getReaderClass();
        result = result * 59 + ($readerClass == null ? 43 : $readerClass.hashCode());
        Map<String, RecordMetaData> $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        return result;
    }

    public String toString() {
        return "RecordMetaDataComposableMap(readerClass=" + this.getReaderClass() + ", meta=" + this.getMeta() + ")";
    }
}

