/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.io;

import java.io.IOException;
import java.util.HashMap;
import org.datavec.api.io.DataInputBuffer;
import org.datavec.api.io.RawComparator;
import org.datavec.api.io.WritableComparable;
import org.datavec.api.util.ReflectionUtils;

public class WritableComparator
implements RawComparator {
    private static HashMap<Class, WritableComparator> comparators = new HashMap();
    private final Class<? extends WritableComparable> keyClass;
    private final WritableComparable key1;
    private final WritableComparable key2;
    private final DataInputBuffer buffer;

    public static synchronized WritableComparator get(Class<? extends WritableComparable> c) {
        WritableComparator comparator = comparators.get(c);
        if (comparator == null) {
            WritableComparator.forceInit(c);
            comparator = comparators.get(c);
            if (comparator == null) {
                comparator = new WritableComparator(c, true);
                comparators.put(c, comparator);
            }
        }
        return comparator;
    }

    private static void forceInit(Class<?> cls) {
        try {
            Class.forName(cls.getName(), true, cls.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't initialize class " + cls, e);
        }
    }

    public static synchronized void define(Class c, WritableComparator comparator) {
        comparators.put(c, comparator);
    }

    protected WritableComparator(Class<? extends WritableComparable> keyClass) {
        this(keyClass, false);
    }

    protected WritableComparator(Class<? extends WritableComparable> keyClass, boolean createInstances) {
        this.keyClass = keyClass;
        if (createInstances) {
            this.key1 = this.newKey();
            this.key2 = this.newKey();
            this.buffer = new DataInputBuffer();
        } else {
            this.key2 = null;
            this.key1 = null;
            this.buffer = null;
        }
    }

    public Class<? extends WritableComparable> getKeyClass() {
        return this.keyClass;
    }

    public WritableComparable newKey() {
        return ReflectionUtils.newInstance(this.keyClass, null);
    }

    @Override
    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        try {
            this.buffer.reset(b1, s1, l1);
            this.key1.readFields(this.buffer);
            this.buffer.reset(b2, s2, l2);
            this.key2.readFields(this.buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.compare(this.key1, this.key2);
    }

    @Override
    public int compare(WritableComparable a, WritableComparable b) {
        return a.compareTo(b);
    }

    @Override
    public int compare(Object a, Object b) {
        return this.compare((WritableComparable)a, (WritableComparable)b);
    }

    public static int compareBytes(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int end1 = s1 + l1;
        int end2 = s2 + l2;
        int i = s1;
        for (int j = s2; i < end1 && j < end2; ++i, ++j) {
            int a = b1[i] & 0xFF;
            int b = b2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return l1 - l2;
    }

    public static int hashBytes(byte[] bytes, int offset, int length) {
        int hash = 1;
        for (int i = offset; i < offset + length; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }

    public static int hashBytes(byte[] bytes, int length) {
        return WritableComparator.hashBytes(bytes, 0, length);
    }

    public static int readUnsignedShort(byte[] bytes, int start) {
        return ((bytes[start] & 0xFF) << 8) + (bytes[start + 1] & 0xFF);
    }

    public static int readInt(byte[] bytes, int start) {
        return ((bytes[start] & 0xFF) << 24) + ((bytes[start + 1] & 0xFF) << 16) + ((bytes[start + 2] & 0xFF) << 8) + (bytes[start + 3] & 0xFF);
    }

    public static float readFloat(byte[] bytes, int start) {
        return Float.intBitsToFloat(WritableComparator.readInt(bytes, start));
    }

    public static long readLong(byte[] bytes, int start) {
        return ((long)WritableComparator.readInt(bytes, start) << 32) + ((long)WritableComparator.readInt(bytes, start + 4) & 0xFFFFFFFFL);
    }

    public static double readDouble(byte[] bytes, int start) {
        return Double.longBitsToDouble(WritableComparator.readLong(bytes, start));
    }

    public static long readVLong(byte[] bytes, int start) throws IOException {
        int len = bytes[start];
        if (len >= -112) {
            return len;
        }
        boolean isNegative = len < -120;
        int n = len = isNegative ? -(len + 120) : -(len + 112);
        if (start + 1 + len > bytes.length) {
            throw new IOException("Not enough number of bytes for a zero-compressed integer");
        }
        long i = 0L;
        for (int idx = 0; idx < len; ++idx) {
            i <<= 8;
            i |= (long)(bytes[start + 1 + idx] & 0xFF);
        }
        return isNegative ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int readVInt(byte[] bytes, int start) throws IOException {
        return (int)WritableComparator.readVLong(bytes, start);
    }
}

