/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.uuid.UUIDGenerator;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.PerspectiveCoordinator;
import org.dashbuilder.displayer.client.export.ExportCallback;
import org.dashbuilder.displayer.client.export.ExportFormat;
import org.dashbuilder.displayer.client.resources.i18n.Constants;
import org.dashbuilder.displayer.client.widgets.DisplayerEditorPopup;
import org.dashbuilder.displayer.client.widgets.DisplayerViewer;
import org.dashbuilder.displayer.json.DisplayerSettingsJSONMarshaller;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.Pull;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@WorkbenchScreen(identifier="DisplayerScreen")
@Dependent
public class DisplayerScreenPresenter {
    private SyncBeanManager beanManager;
    private DataSetClientServices dataSetClientServices;
    private DisplayerViewer displayerViewer;
    private PerspectiveCoordinator perspectiveCoordinator;
    private PerspectiveManager perspectiveManager;
    private PanelManager panelManager;
    private PlaceManager placeManager;
    private UUIDGenerator uuidGenerator;
    private Event<ChangeTitleWidgetEvent> changeTitleEvent;
    private DisplayerSettingsJSONMarshaller jsonMarshaller;
    private DisplayerSettings displayerSettings;
    private PlaceRequest placeRequest;
    private Menus menu = null;
    private boolean editEnabled = false;
    private boolean cloneEnabled = false;
    private boolean csvExportAllowed = false;
    private boolean excelExportAllowed = false;
    private ButtonGroup menuActionsButton;
    private static final int MAX_EXPORT_LIMIT = 100000;

    @Inject
    public DisplayerScreenPresenter(SyncBeanManager beanManager, DataSetClientServices dataSetClientServices, UUIDGenerator uuidGenerator, PerspectiveManager perspectiveManager, PlaceManager placeManager, DisplayerViewer displayerViewer, PanelManager panelManager, PerspectiveCoordinator perspectiveCoordinator, Event<ChangeTitleWidgetEvent> changeTitleEvent) {
        this.beanManager = beanManager;
        this.dataSetClientServices = dataSetClientServices;
        this.uuidGenerator = uuidGenerator;
        this.placeManager = placeManager;
        this.perspectiveManager = perspectiveManager;
        this.displayerViewer = displayerViewer;
        this.panelManager = panelManager;
        this.perspectiveCoordinator = perspectiveCoordinator;
        this.menuActionsButton = this.getMenuActionsButton();
        this.changeTitleEvent = changeTitleEvent;
        this.jsonMarshaller = DisplayerSettingsJSONMarshaller.get();
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
        String json = placeRequest.getParameter("json", "");
        if (!StringUtils.isBlank((String)json)) {
            this.displayerSettings = this.jsonMarshaller.fromJsonString(json);
        }
        if (this.displayerSettings == null) {
            throw new IllegalArgumentException(Constants.INSTANCE.displayer_presenter_displayer_notfound());
        }
        Boolean showRendererSelector = Boolean.parseBoolean(placeRequest.getParameter("showRendererSelector", "false"));
        this.displayerViewer.setIsShowRendererSelector(showRendererSelector);
        if (StringUtils.isBlank((String)this.displayerSettings.getUUID())) {
            this.displayerSettings.setUUID(this.uuidGenerator.newUuid());
        }
        this.displayerViewer.init(this.displayerSettings);
        Displayer displayer = this.displayerViewer.draw();
        this.perspectiveCoordinator.addDisplayer(displayer);
        String edit = placeRequest.getParameter("edit", "false");
        String clone = placeRequest.getParameter("clone", "false");
        this.editEnabled = Boolean.parseBoolean(edit);
        this.cloneEnabled = Boolean.parseBoolean(clone);
        this.csvExportAllowed = this.displayerSettings.isCSVExportAllowed();
        this.excelExportAllowed = this.displayerSettings.isExcelExportAllowed();
        this.menu = this.makeMenuBar();
        this.adjustMenuActions(this.displayerSettings);
    }

    @OnClose
    public void onClose() {
        this.removeDisplayer();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.displayerSettings.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.displayerViewer;
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        menusConsumer.accept(this.menu);
    }

    private Menus makeMenuBar() {
        return ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        return DisplayerScreenPresenter.this.menuActionsButton;
                    }

                    public boolean isEnabled() {
                        return DisplayerScreenPresenter.this.editEnabled || DisplayerScreenPresenter.this.cloneEnabled || DisplayerScreenPresenter.this.csvExportAllowed || DisplayerScreenPresenter.this.excelExportAllowed;
                    }

                    public void setEnabled(boolean enabled) {
                    }
                };
            }
        }).endMenu()).build();
    }

    private Command getEditCommand() {
        return () -> {
            this.perspectiveCoordinator.editOn();
            String currentTitle = this.displayerSettings.getTitle();
            DisplayerEditorPopup displayerEditor = (DisplayerEditorPopup)this.beanManager.lookupBean(DisplayerEditorPopup.class, new Annotation[0]).newInstance();
            displayerEditor.init(this.displayerSettings.cloneInstance());
            displayerEditor.setOnSaveCommand(this.getSaveCommand(displayerEditor, currentTitle));
            displayerEditor.setOnCloseCommand(this.getCloseCommand(displayerEditor));
        };
    }

    protected Command getCloneCommand() {
        return () -> {
            this.perspectiveCoordinator.editOn();
            DisplayerSettings clonedSettings = this.displayerSettings.cloneInstance();
            clonedSettings.setUUID(this.uuidGenerator.newUuid());
            clonedSettings.setTitle("Copy of " + clonedSettings.getTitle());
            DisplayerEditorPopup displayerEditor = (DisplayerEditorPopup)this.beanManager.lookupBean(DisplayerEditorPopup.class, new Annotation[0]).newInstance();
            displayerEditor.init(clonedSettings);
            displayerEditor.setOnSaveCommand(this.getSaveCloneCommand(displayerEditor));
            displayerEditor.setOnCloseCommand(this.getCloseCommand(displayerEditor));
        };
    }

    protected Command getSaveCommand(DisplayerEditorPopup displayerEditor, String currentTitle) {
        return () -> {
            this.perspectiveCoordinator.editOff();
            DisplayerSettings newSettings = displayerEditor.getDisplayerSettings();
            if (!this.displayerSettings.equals((Object)newSettings)) {
                String newTitle = newSettings.getTitle();
                if (!currentTitle.equals(newTitle)) {
                    this.changeTitleEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, newSettings.getTitle()));
                }
                PanelDefinition panelDefinition = this.panelManager.getPanelForPlace(this.placeRequest);
                this.beanManager.destroyBean((Object)displayerEditor);
                this.placeManager.goTo(this.createPlaceRequest(newSettings), panelDefinition);
                this.placeManager.closePlace(this.placeRequest);
                this.perspectiveManager.savePerspectiveState(() -> {});
            }
        };
    }

    protected Command getSaveCloneCommand(DisplayerEditorPopup displayerEditor) {
        return () -> {
            this.perspectiveCoordinator.editOff();
            this.beanManager.destroyBean((Object)displayerEditor);
            PanelDefinition panelDefinition = this.panelManager.getPanelForPlace(this.placeRequest);
            this.placeManager.goTo(this.createPlaceRequest(displayerEditor.getDisplayerSettings()), panelDefinition);
            this.perspectiveManager.savePerspectiveState(() -> {});
        };
    }

    protected Command getCloseCommand(DisplayerEditorPopup displayerEditor) {
        return () -> {
            this.perspectiveCoordinator.editOff();
            this.beanManager.destroyBean((Object)displayerEditor);
        };
    }

    protected Command getExportCsvCommand() {
        return this.getExportCommand(ExportFormat.CSV);
    }

    protected Command getExportExcelCommand() {
        return this.getExportCommand(ExportFormat.XLS);
    }

    protected Command getExportCommand(ExportFormat format) {
        return () -> this.displayerViewer.getDisplayer().export(format, 100000, new ExportCallback(){

            public void noData() {
                Window.alert((String)Constants.INSTANCE.displayer_presenter_export_no_data());
            }

            public void tooManyRows(int rowNum) {
                Window.alert((String)Constants.INSTANCE.displayer_presenter_export_large_dataset());
            }

            public void exportFileUrl(String url) {
                Window.open((String)url, (String)"downloading", (String)"resizable=no,scrollbars=yes,status=no");
            }

            public void error(ClientRuntimeError error) {
                DisplayerScreenPresenter.this.displayerViewer.error(error);
            }
        });
    }

    protected void removeDisplayer() {
        Displayer displayer = this.displayerViewer.getDisplayer();
        this.perspectiveCoordinator.removeDisplayer(displayer);
        displayer.close();
        this.beanManager.destroyBean((Object)this.displayerViewer);
    }

    protected PlaceRequest createPlaceRequest(DisplayerSettings displayerSettings) {
        String json = this.jsonMarshaller.toJsonString(displayerSettings);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("json", json);
        params.put("edit", "true");
        params.put("clone", "true");
        return new DefaultPlaceRequest("DisplayerScreen", params);
    }

    protected void adjustMenuActions(DisplayerSettings displayerSettings) {
        ComplexPanel menu = (ComplexPanel)this.menuActionsButton.getWidget(1);
        menu.getWidget(2).setVisible(displayerSettings.isCSVExportAllowed());
        menu.getWidget(3).setVisible(displayerSettings.isExcelExportAllowed());
    }

    protected ButtonGroup getMenuActionsButton() {
        return new ButtonGroup(){
            {
                this.add((Widget)new Button(Constants.INSTANCE.menu_button_actions()){
                    {
                        this.setSize(ButtonSize.EXTRA_SMALL);
                        this.addStyleName(Pull.RIGHT.getCssName());
                        this.setDataToggle(Toggle.DROPDOWN);
                    }
                });
                this.add((Widget)new DropDownMenu(){
                    {
                        this.add((Widget)new AnchorListItem(Constants.INSTANCE.menu_edit()){
                            {
                                this.addClickHandler(event -> DisplayerScreenPresenter.this.getEditCommand().execute());
                            }
                        });
                        this.add((Widget)new AnchorListItem(Constants.INSTANCE.menu_clone()){
                            {
                                this.addClickHandler(event -> DisplayerScreenPresenter.this.getCloneCommand().execute());
                            }
                        });
                        this.add((Widget)new AnchorListItem(Constants.INSTANCE.menu_export_csv()){
                            {
                                this.addClickHandler(event -> DisplayerScreenPresenter.this.getExportCsvCommand().execute());
                            }
                        });
                        this.add((Widget)new AnchorListItem(Constants.INSTANCE.menu_export_excel()){
                            {
                                this.addClickHandler(event -> DisplayerScreenPresenter.this.getExportExcelCommand().execute());
                            }
                        });
                    }
                });
            }
        };
    }
}

