/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Utils {
    private static final String HEX_DIGITS = "0123456789ABCDEF";

    Utils() {
    }

    static boolean isInRange(char c, char start, char end) {
        return start <= c && c <= end;
    }

    static boolean isDigit(char c) {
        return Utils.isInRange(c, '0', '9');
    }

    static boolean isAlphabet(char c) {
        return Utils.isInRange(c, 'a', 'z') || Utils.isInRange(c, 'A', 'Z');
    }

    static boolean isUnreserved(char c) {
        return Utils.isAlphabet(c) || Utils.isDigit(c) || c == '-' || c == '.' || c == '_' || c == '~';
    }

    static boolean isSubdelim(char c) {
        return c == '!' || c == '$' || c == '&' || c == '\'' || c == '(' || c == ')' || c == '*' || c == '+' || c == ',' || c == ';' || c == '=';
    }

    static boolean isHexDigit(char c) {
        return Utils.isDigit(c) || Utils.isInRange(c, 'a', 'f') || Utils.isInRange(c, 'A', 'F');
    }

    static char toHexDigit(int i) {
        if (i < 0) {
            throw Utils.newIAE("The input integer is less than 0.", new Object[0]);
        }
        if (i > 16) {
            throw Utils.newIAE("The input integer is larger than 16.", new Object[0]);
        }
        return HEX_DIGITS.charAt(i);
    }

    static int fromHexDigit(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return 10 + c - 97;
        }
        if ('A' <= c && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }

    static String removeDotSegments(String path) {
        String input = path;
        Object output = "";
        while (input.length() > 0) {
            Matcher m = Pattern.compile("^\\.?\\.\\/").matcher(input);
            if (m.find()) {
                input = m.replaceFirst("");
                continue;
            }
            m = Pattern.compile("^\\/\\.(\\/|$)").matcher(input);
            if (m.find()) {
                input = m.replaceFirst("/");
                continue;
            }
            m = Pattern.compile("^\\/\\.\\.(\\/|$)").matcher(input);
            if (m.find()) {
                input = m.replaceFirst("/");
                output = Utils.dropLastSegment((String)output, true);
                continue;
            }
            m = Pattern.compile("^\\.?\\.$").matcher(input);
            if (m.find()) {
                input = m.replaceFirst("");
                continue;
            }
            m = Pattern.compile("^(?<firstsegment>\\/?[^/]*)(?<remaining>.*)$").matcher(input);
            if (!m.find()) continue;
            input = m.group("remaining");
            output = (String)output + m.group("firstsegment");
        }
        return output;
    }

    static String dropLastSegment(String path, boolean dropLastSlash) {
        String regex = dropLastSlash ? "\\/?[^/]*$" : "[^/]*$";
        Matcher m = Pattern.compile(regex).matcher(path);
        m.find();
        return m.replaceFirst("");
    }

    static NullPointerException newNPE(String msg, Object ... args) {
        return new NullPointerException(String.format(msg, args));
    }

    static IllegalArgumentException newIAE(String msg, Object ... args) {
        return new IllegalArgumentException(String.format(msg, args));
    }

    static IllegalStateException newISE(String msg, Object ... args) {
        return new IllegalStateException(String.format(msg, args));
    }
}

