/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.czeal.rfc3986.AuthorityBuilder;
import org.czeal.rfc3986.FragmentValidator;
import org.czeal.rfc3986.Host;
import org.czeal.rfc3986.PathSegments;
import org.czeal.rfc3986.PathValidator;
import org.czeal.rfc3986.QueryParams;
import org.czeal.rfc3986.QueryValidator;
import org.czeal.rfc3986.SchemeValidator;
import org.czeal.rfc3986.URIReference;
import org.czeal.rfc3986.Utils;

public class URIReferenceBuilder {
    private Charset charset;
    private String scheme;
    private String userinfo;
    private String host;
    private int port = -1;
    private PathSegments pathSegments;
    private QueryParams queryParams;
    private String fragment;
    private boolean authorityRequired = true;

    public static URIReferenceBuilder fromURIReference(String uriRef) {
        return URIReferenceBuilder.fromURIReference(URIReference.parse(uriRef));
    }

    public static URIReferenceBuilder fromURIReference(URIReference uriRef) {
        return new URIReferenceBuilder().uriRef(uriRef);
    }

    public URIReferenceBuilder uriRef(URIReference uriRef) {
        if (uriRef == null) {
            throw Utils.newNPE("The URI reference must not be null.", new Object[0]);
        }
        this.charset = uriRef.getCharset();
        this.scheme = uriRef.getScheme();
        this.userinfo = uriRef.getUserinfo();
        this.host = Optional.ofNullable(uriRef.getHost()).map(Host::getValue).orElse(null);
        this.port = uriRef.getPort();
        this.pathSegments = PathSegments.parse(uriRef.getPath());
        this.queryParams = QueryParams.parse(uriRef.getQuery());
        this.fragment = uriRef.getFragment();
        return this;
    }

    public URIReferenceBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public URIReferenceBuilder setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public URIReferenceBuilder setUserinfo(String userinfo) {
        this.userinfo = userinfo;
        return this;
    }

    public URIReferenceBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public URIReferenceBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public URIReferenceBuilder setPath(String path) {
        this.pathSegments = PathSegments.parse(path);
        return this;
    }

    public URIReferenceBuilder setQuery(String query) {
        this.queryParams = QueryParams.parse(query);
        return this;
    }

    public URIReferenceBuilder setFragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public URIReferenceBuilder setAuthorityRequired(boolean authorityRequired) {
        this.authorityRequired = authorityRequired;
        return this;
    }

    public URIReferenceBuilder appendQueryParam(String key, String value) {
        if (this.queryParams == null) {
            this.queryParams = new QueryParams();
        }
        this.queryParams.add(key, value);
        return this;
    }

    public URIReferenceBuilder replaceQueryParam(String key, String value) {
        if (this.queryParams != null) {
            this.queryParams.replace(key, value);
        }
        return this;
    }

    public URIReferenceBuilder removeQueryParam(String key) {
        if (this.queryParams != null) {
            this.queryParams.remove(key);
        }
        return this;
    }

    public URIReferenceBuilder appendPathSegments(String ... segment) {
        if (this.pathSegments == null) {
            this.pathSegments = new PathSegments();
        }
        this.pathSegments = this.pathSegments.add(segment);
        return this;
    }

    public URIReference build() {
        URIReference.ProcessResult res = new URIReference.ProcessResult();
        this.processCharset(res);
        this.processScheme(res);
        this.processAuthority(res);
        this.processPath(res);
        this.processQuery(res);
        this.processFragment(res);
        return res.toURIReference();
    }

    private void processCharset(URIReference.ProcessResult res) {
        res.charset = this.charset != null ? this.charset : StandardCharsets.UTF_8;
    }

    private void processScheme(URIReference.ProcessResult res) {
        if (this.scheme != null) {
            new SchemeValidator().validate(this.scheme);
            res.scheme = this.scheme;
            res.relativeReference = false;
        } else {
            res.relativeReference = true;
        }
    }

    private void processAuthority(URIReference.ProcessResult res) {
        if (!this.authorityRequired) {
            return;
        }
        res.authority = new AuthorityBuilder().setCharset(this.charset).setUserinfo(this.userinfo).setHost(this.host).setPort(this.port).build();
    }

    private void processPath(URIReference.ProcessResult res) {
        String path = this.pathSegments == null ? null : this.pathSegments.toString();
        new PathValidator().validate(path, res.charset, res.relativeReference, res.authority != null);
        res.path = path;
    }

    private void processQuery(URIReference.ProcessResult res) {
        String query = this.queryParams == null || this.queryParams.isEmpty() ? null : this.queryParams.toString();
        new QueryValidator().validate(query, res.charset);
        res.query = query;
    }

    private void processFragment(URIReference.ProcessResult res) {
        new FragmentValidator().validate(this.fragment, res.charset);
        res.fragment = this.fragment;
    }
}

