/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.czeal.rfc3986.Authority;
import org.czeal.rfc3986.Host;
import org.czeal.rfc3986.URIReferenceNormalizer;
import org.czeal.rfc3986.URIReferenceParser;
import org.czeal.rfc3986.URIReferenceResolver;

public class URIReference
implements Serializable,
Comparable<URIReference> {
    private static final long serialVersionUID = 1L;
    private final Charset charset;
    private final boolean relativeReference;
    private final String scheme;
    private final Authority authority;
    private final String path;
    private final String query;
    private final String fragment;

    public static URIReference parse(String uriRef) {
        return URIReference.parse(uriRef, StandardCharsets.UTF_8);
    }

    public static URIReference parse(String uriRef, Charset charset) {
        return new URIReferenceParser().parse(uriRef, charset);
    }

    private URIReference(ProcessResult res) {
        this.charset = res.charset;
        this.relativeReference = res.relativeReference;
        this.scheme = res.scheme;
        this.authority = res.authority;
        this.path = res.path;
        this.query = res.query;
        this.fragment = res.fragment;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isRelativeReference() {
        return this.relativeReference;
    }

    public String getScheme() {
        return this.scheme;
    }

    public Authority getAuthority() {
        return this.authority;
    }

    public String getUserinfo() {
        return this.hasAuthority() ? this.getAuthority().getUserinfo() : null;
    }

    public Host getHost() {
        return this.hasAuthority() ? this.getAuthority().getHost() : null;
    }

    public int getPort() {
        return this.hasAuthority() ? this.getAuthority().getPort() : -1;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean hasAuthority() {
        return this.getAuthority() != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getScheme() != null) {
            sb.append(this.getScheme()).append(":");
        }
        if (this.getAuthority() != null) {
            sb.append("//").append(this.getAuthority().toString());
        }
        if (this.getPath() != null) {
            sb.append(this.getPath());
        }
        if (this.getQuery() != null) {
            sb.append("?").append(this.getQuery());
        }
        if (this.getFragment() != null) {
            sb.append("#").append(this.getFragment());
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof URIReference)) {
            return false;
        }
        return this.compareTo((URIReference)other) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.getScheme(), this.getAuthority(), this.getPath(), this.getQuery(), this.getFragment());
    }

    @Override
    public int compareTo(URIReference other) {
        return this.hashCode() - other.hashCode();
    }

    public URIReference resolve(String uriRef) {
        return this.resolve(URIReference.parse(uriRef, this.getCharset()));
    }

    public URIReference resolve(URIReference uriRef) {
        return new URIReferenceResolver().resolve(uriRef, this);
    }

    public URIReference normalize() {
        return new URIReferenceNormalizer().normalize(this);
    }

    static class ProcessResult {
        Charset charset;
        boolean relativeReference;
        String scheme;
        Authority authority;
        String path;
        String query;
        String fragment;

        ProcessResult() {
        }

        URIReference toURIReference() {
            return new URIReference(this);
        }
    }
}

