/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.czeal.rfc3986.HostParser;
import org.czeal.rfc3986.HostType;

public class Host
implements Serializable,
Comparable<Host> {
    private static final long serialVersionUID = 1L;
    private final HostType type;
    private final String value;

    static Host parse(String host) {
        return Host.parse(host, StandardCharsets.UTF_8);
    }

    static Host parse(String host, Charset charset) {
        return new HostParser().parse(host, charset);
    }

    Host(HostType type, String value) {
        this.type = type;
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public HostType getType() {
        return this.type;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Host)) {
            return false;
        }
        return this.compareTo((Host)other) == 0;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    @Override
    public int compareTo(Host other) {
        return this.hashCode() - other.hashCode();
    }
}

