/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.spi;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jcli.spi.ArgumentDefinition;
import org.cyclopsgroup.jcli.spi.CliDefinition;
import org.cyclopsgroup.jcli.spi.OptionDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CliUtils {
    private static final String ERROR_MESSAGE = "Couldn't set value %s to %s#%s";
    private static final Log LOG = LogFactory.getLog(CliUtils.class);

    public static CliDefinition defineCli(Class<?> beanType) throws IntrospectionException {
        Cli cliAnnotation = beanType.getAnnotation(Cli.class);
        Validate.notNull((Object)cliAnnotation, (String)("Type " + beanType + " has to be annotated with @Cli"));
        BeanInfo beanInfo = Introspector.getBeanInfo(beanType);
        CliDefinition cliDefinition = new CliDefinition(cliAnnotation);
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            Argument argument;
            Method writer = descriptor.getWriteMethod();
            if (writer == null) continue;
            Option option = CliUtils.getAnnotation(descriptor, Option.class);
            if (option != null) {
                OptionDefinition def = new OptionDefinition(option, descriptor);
                cliDefinition.addOption(def);
            }
            if ((argument = CliUtils.getAnnotation(descriptor, Argument.class)) == null) continue;
            cliDefinition.setArgument(new ArgumentDefinition(argument, descriptor));
        }
        return cliDefinition;
    }

    private static <A extends Annotation> A getAnnotation(PropertyDescriptor descriptor, Class<A> type) {
        A a = null;
        if (descriptor.getWriteMethod() != null) {
            a = descriptor.getWriteMethod().getAnnotation(type);
        }
        if (a == null && descriptor.getReadMethod() != null) {
            a = descriptor.getReadMethod().getAnnotation(type);
        }
        return a;
    }

    public static void setValue(Object bean, PropertyDescriptor prop, Object value) {
        Validate.notNull((Object)bean, (String)"Java bean can't be NULL");
        Validate.notNull((Object)prop, (String)"Java property descriptor can't be NULL");
        try {
            prop.getWriteMethod().invoke(bean, value);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)String.format(ERROR_MESSAGE, value, bean, prop));
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)String.format(ERROR_MESSAGE, value, bean, prop));
        }
        catch (InvocationTargetException e) {
            LOG.warn((Object)String.format(ERROR_MESSAGE, value, bean, prop));
        }
    }

    public static void setValue(Object bean, PropertyDescriptor prop, String value) {
        Object v = prop.getPropertyType() == String.class ? value : ConvertUtils.convert((String)value, prop.getPropertyType());
        CliUtils.setValue(bean, prop, v);
    }

    public static void setValues(Object bean, PropertyDescriptor prop, String[] values) {
        Object v;
        Validate.notNull((Object)bean, (String)"Java bean can't be NULL");
        Validate.notNull((Object)prop, (String)"Java property descriptor can't be NULL");
        Validate.notNull((Object)values, (String)"Values can't be NULL");
        Class<?> type = prop.getPropertyType();
        if (prop.getPropertyType().isArray()) {
            if (type.getComponentType() == String.class) {
                v = values;
            } else {
                Object[] valueArray = new Object[values.length];
                for (int i = 0; i < values.length; ++i) {
                    valueArray[i] = ConvertUtils.convert((String)values[i], type.getComponentType());
                }
                v = valueArray;
            }
        } else {
            v = List.class.isAssignableFrom(type) ? Arrays.asList(values) : (values.length == 0 ? null : values[0]);
        }
        CliUtils.setValue(bean, prop, v);
    }

    private CliUtils() {
    }
}

