/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.jline;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import jline.Completor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.AutoCompletable;
import org.cyclopsgroup.jcli.StringTokenizer;
import org.cyclopsgroup.jcli.jline.ArgumentsInspector;
import org.cyclopsgroup.jcli.spi.CliDefinition;
import org.cyclopsgroup.jcli.spi.CliUtils;
import org.cyclopsgroup.jcli.spi.OptionDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CliCompletor
implements Completor {
    private final CliDefinition cli;
    private final AutoCompletable completable;
    private final StringTokenizer tokenizer;

    private static List<String> filterList(List<String> list, String prefix) {
        if (StringUtils.isEmpty((String)prefix) || list == null) {
            return list;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String item : list) {
            if (!item.startsWith(prefix)) continue;
            results.add(item);
        }
        return results;
    }

    public CliCompletor(Object cliBean, StringTokenizer tokenizer) throws IntrospectionException {
        Validate.notNull((Object)cliBean, (String)"Cli bean can't be NULL");
        Validate.notNull((Object)tokenizer, (String)"String tokenizer can't be NULL");
        this.cli = CliUtils.defineCli(cliBean.getClass());
        this.completable = cliBean instanceof AutoCompletable ? (AutoCompletable)cliBean : new AutoCompletable(){

            @Override
            public List<String> suggestArgument(String partialArgument) {
                return Collections.emptyList();
            }

            @Override
            public List<String> suggestOption(String optionName, String partialOption) {
                return Collections.emptyList();
            }
        };
        this.tokenizer = tokenizer;
    }

    public int complete(String command, int cursor, List suggestions) {
        ArgumentsInspector inspector = new ArgumentsInspector(this.cli);
        final AtomicBoolean terminated = new AtomicBoolean(true);
        final AtomicInteger lastWordStart = new AtomicInteger(0);
        if (StringUtils.isNotEmpty((String)command)) {
            final ArrayList args = new ArrayList();
            this.tokenizer.parse(command, new StringTokenizer.TokenEventHandler(){

                public void handleWordEvent(String word, int start, int end, boolean t) {
                    args.add(word);
                    terminated.set(t);
                    lastWordStart.set(start);
                }
            });
            for (String arg : args) {
                inspector.consume(arg);
            }
            if (terminated.get()) {
                inspector.end();
            }
        }
        ArrayList<String> candidates = new ArrayList<String>();
        switch (inspector.getState()) {
            case READY: {
                for (OptionDefinition o : inspector.getRemainingOptions()) {
                    candidates.add("-" + o.getName());
                }
                Collections.sort(candidates);
                candidates.addAll(this.suggestArguments(null));
                break;
            }
            case OPTION: 
            case LONG_OPTION: {
                candidates.addAll(this.suggestOptionNames(inspector, inspector.getCurrentValue()));
                break;
            }
            case OPTION_VALUE: {
                candidates.addAll(this.suggestOptionValue(inspector.getCurrentOption(), inspector.getCurrentValue()));
                break;
            }
            case ARGUMENT: {
                candidates.addAll(this.suggestArguments(inspector.getCurrentValue()));
            }
        }
        for (String candidate : candidates) {
            suggestions.add(this.tokenizer.escape(candidate));
        }
        if (StringUtils.isEmpty((String)command)) {
            return 0;
        }
        if (terminated.get()) {
            return cursor;
        }
        return lastWordStart.get();
    }

    private List<String> suggestArguments(String partialArgument) {
        List<String> results;
        if (StringUtils.isEmpty((String)partialArgument)) {
            results = this.completable.suggestArgument(null);
        } else {
            results = this.completable.suggestArgument(partialArgument);
            if (results == null) {
                results = CliCompletor.filterList(this.completable.suggestArgument(null), partialArgument);
            }
        }
        if (results == null) {
            results = Collections.emptyList();
        } else {
            results = new ArrayList<String>(results);
            Collections.sort(results);
        }
        return results;
    }

    private List<String> suggestOptionNames(ArgumentsInspector inspector, String value) {
        ArrayList<String> results = new ArrayList<String>();
        for (OptionDefinition o : inspector.getRemainingOptions()) {
            if (value.startsWith("--") && o.getOption().longName() != null && ("--" + o.getOption().longName()).startsWith(value)) {
                results.add("--" + o.getOption().longName());
                continue;
            }
            if (!value.startsWith("-") || !("-" + o.getOption().name()).startsWith(value)) continue;
            results.add("-" + o.getOption().name());
        }
        Collections.sort(results);
        return results;
    }

    private List<String> suggestOptionValue(OptionDefinition option, String partialValue) {
        List<String> results;
        if (StringUtils.isEmpty((String)partialValue)) {
            results = this.completable.suggestOption(option.getName(), null);
        } else {
            results = this.completable.suggestOption(option.getName(), partialValue);
            if (results == null) {
                results = CliCompletor.filterList(this.completable.suggestOption(option.getName(), null), partialValue);
            }
        }
        if (results == null) {
            results = Collections.emptyList();
        } else {
            results = new ArrayList<String>(results);
            Collections.sort(results);
        }
        return results;
    }
}

