/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.jline;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.cyclopsgroup.jcli.jline.ArgumentsInspectorState;
import org.cyclopsgroup.jcli.spi.CliDefinition;
import org.cyclopsgroup.jcli.spi.OptionDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArgumentsInspector {
    private final CliDefinition cli;
    private OptionDefinition currentOption;
    private String currentValue;
    private final Set<OptionDefinition> remainingOptions;
    private ArgumentsInspectorState state = ArgumentsInspectorState.READY;

    ArgumentsInspector(CliDefinition cli) {
        this.cli = cli;
        this.remainingOptions = new HashSet<OptionDefinition>(cli.getOptions().values());
    }

    void consume(String argument) {
        if (argument.startsWith("--")) {
            this.state = ArgumentsInspectorState.LONG_OPTION;
        } else if (argument.startsWith("-")) {
            this.state = ArgumentsInspectorState.OPTION;
        } else {
            switch (this.state) {
                case READY: {
                    this.state = ArgumentsInspectorState.ARGUMENT;
                    break;
                }
                case OPTION: {
                    this.currentOption = this.findOptionByName(this.currentValue);
                }
                case LONG_OPTION: {
                    if (this.state == ArgumentsInspectorState.LONG_OPTION) {
                        this.currentOption = this.findOptionByLongName(this.currentValue);
                    }
                    if (this.currentOption != null && !this.currentOption.isMultiValue()) {
                        this.remainingOptions.remove(this.currentOption);
                    }
                    if (this.currentOption == null || this.currentOption.isFlag()) {
                        this.state = ArgumentsInspectorState.ARGUMENT;
                        break;
                    }
                    this.state = ArgumentsInspectorState.OPTION_VALUE;
                    break;
                }
                case OPTION_VALUE: 
                case ARGUMENT: {
                    this.state = ArgumentsInspectorState.ARGUMENT;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this.currentValue = argument;
    }

    void end() {
        switch (this.state) {
            case OPTION: {
                this.currentOption = this.findOptionByName(this.currentValue);
            }
            case LONG_OPTION: {
                if (this.state == ArgumentsInspectorState.LONG_OPTION) {
                    this.currentOption = this.findOptionByLongName(this.currentValue);
                }
                if (this.currentOption != null && !this.currentOption.isMultiValue()) {
                    this.remainingOptions.remove(this.currentOption);
                }
                if (this.currentOption == null || this.currentOption.isFlag()) {
                    this.state = ArgumentsInspectorState.ARGUMENT;
                    break;
                }
                this.state = ArgumentsInspectorState.OPTION_VALUE;
                break;
            }
            default: {
                this.state = ArgumentsInspectorState.READY;
            }
        }
        this.currentValue = null;
    }

    private OptionDefinition findOptionByLongName(String longName) {
        for (OptionDefinition o : this.cli.getOptions().values()) {
            if (o.getOption().longName() == null || !StringUtils.equals((String)("--" + o.getOption().longName()), (String)longName)) continue;
            return o;
        }
        return null;
    }

    private OptionDefinition findOptionByName(String name) {
        return this.cli.getOptions().get(name.substring(1));
    }

    OptionDefinition getCurrentOption() {
        return this.currentOption;
    }

    String getCurrentValue() {
        return this.currentValue;
    }

    Set<OptionDefinition> getRemainingOptions() {
        return Collections.unmodifiableSet(this.remainingOptions);
    }

    ArgumentsInspectorState getState() {
        return this.state;
    }
}

